/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class ImportDataFunction
extends CliFunction<Object[]> {
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.ImportDataFunction";

    public String getId() {
        return ID;
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) throws Exception {
        CliFunctionResult result;
        Object[] args = (Object[])context.getArguments();
        if (args.length < 4) {
            throw new IllegalStateException("Arguments length does not match required length. Import command may have been sent from incompatible older version");
        }
        String regionName = (String)args[0];
        String importFileName = (String)args[1];
        boolean invokeCallbacks = (Boolean)args[2];
        boolean parallel = (Boolean)args[3];
        InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
        Region region = cache.getRegion(regionName);
        String hostName = cache.getDistributedSystem().getDistributedMember().getHost();
        if (region != null) {
            RegionSnapshotService snapshotService = region.getSnapshotService();
            SnapshotOptions options = snapshotService.createOptions();
            options.invokeCallbacks(invokeCallbacks);
            options.setParallelMode(parallel);
            File importFile = new File(importFileName);
            snapshotService.load(new File(importFileName), SnapshotOptions.SnapshotFormat.GEODE, options);
            String successMessage = CliStrings.format((String)"Data imported from file : {0} on host : {1} to region : {2}", (Object[])new Object[]{importFile.getCanonicalPath(), hostName, regionName});
            result = new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, successMessage);
        } else {
            result = new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"Region : {0} not found", (Object)regionName));
        }
        return result;
    }
}

