/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.help;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class HelpBlock {
    private String data = null;
    private final List<HelpBlock> children = new ArrayList<HelpBlock>();
    private int level = -1;

    public HelpBlock() {
    }

    public HelpBlock(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            this.data = data;
            this.level = 0;
        }
    }

    public String getData() {
        return this.data;
    }

    public List<HelpBlock> getChildren() {
        return this.children;
    }

    public int getLevel() {
        return this.level;
    }

    public void addChild(HelpBlock helpBlock) {
        helpBlock.setLevel(this.level + 1);
        this.children.add(helpBlock);
    }

    public void setLevel(int level) {
        this.level = level;
        for (HelpBlock child : this.children) {
            child.setLevel(level + 1);
        }
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int terminalWidth) {
        StringBuilder builder = new StringBuilder();
        if (this.data != null) {
            builder.append(Gfsh.wrapText(this.data, this.level, terminalWidth));
            builder.append(GfshParser.LINE_SEPARATOR);
        }
        for (HelpBlock child : this.children) {
            builder.append(child.toString(terminalWidth));
        }
        return builder.toString();
    }
}

