/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Objects;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.configuration.DiskDir;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.runtime.DiskStoreInfo;

@Experimental
public class DiskStore
extends GroupableConfiguration<DiskStoreInfo> {
    public static final String DISK_STORE_CONFIG_ENDPOINT = "/diskstores";
    private String name;
    private Integer compactionThreshold;
    private Float diskUsageCriticalPercentage;
    private Float diskUsageWarningPercentage;
    private Long maxOplogSizeInBytes;
    private Integer queueSize;
    private Long timeInterval;
    private Integer writeBufferSize;
    private List<DiskDir> directories;
    private Boolean allowForceCompaction;
    private Boolean autoCompact;

    public Boolean isAutoCompact() {
        return this.autoCompact;
    }

    public void setAutoCompact(Boolean autoCompact) {
        this.autoCompact = autoCompact;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DiskDir> getDirectories() {
        return this.directories;
    }

    public void setDirectories(List<DiskDir> directories) {
        this.directories = directories;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.name;
    }

    public Integer getCompactionThreshold() {
        return this.compactionThreshold;
    }

    public void setCompactionThreshold(Integer compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
    }

    public Float getDiskUsageCriticalPercentage() {
        return this.diskUsageCriticalPercentage;
    }

    public void setDiskUsageCriticalPercentage(Float diskUsageCriticalPercentage) {
        this.diskUsageCriticalPercentage = diskUsageCriticalPercentage;
    }

    public Float getDiskUsageWarningPercentage() {
        return this.diskUsageWarningPercentage;
    }

    public void setDiskUsageWarningPercentage(Float diskUsageWarningPercentage) {
        this.diskUsageWarningPercentage = diskUsageWarningPercentage;
    }

    public Long getMaxOplogSizeInBytes() {
        return this.maxOplogSizeInBytes;
    }

    public void setMaxOplogSizeInBytes(Long maxOplogSize) {
        this.maxOplogSizeInBytes = maxOplogSize;
    }

    public Integer getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public Long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(Long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public Integer getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(Integer writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public Boolean isAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    public void setAllowForceCompaction(Boolean allowForceCompaction) {
        this.allowForceCompaction = allowForceCompaction;
    }

    @Override
    public Links getLinks() {
        return new Links(this.getId(), DISK_STORE_CONFIG_ENDPOINT);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiskStore diskStore = (DiskStore)o;
        return Objects.equals(this.name, diskStore.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }
}

