/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.IndexType;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.configuration.RegionScoped;
import org.apache.geode.management.runtime.IndexInfo;

public class Index
extends AbstractConfiguration<IndexInfo>
implements RegionScoped {
    public static final String INDEXES = "/indexes";
    private String name;
    private String expression;
    private String regionPath;
    private IndexType indexType;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public void setRegionPath(String regionPath) {
        this.regionPath = regionPath;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    @Override
    @JsonIgnore
    public String getRegionName() {
        if (this.regionPath == null) {
            return null;
        }
        String regionName = this.regionPath.trim().split(" ")[0];
        if ((regionName = StringUtils.removeStart((String)regionName, (String)"/")).contains(".")) {
            regionName = regionName.substring(0, regionName.indexOf(46));
        }
        return regionName;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getName();
    }

    @Override
    public Links getLinks() {
        String regionName = this.getRegionName();
        if (StringUtils.isBlank((CharSequence)regionName)) {
            return new Links(null, INDEXES);
        }
        Links links = new Links(this.getId(), "/regions/" + regionName + INDEXES);
        links.addLink("region", "/regions/" + regionName);
        return links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        if (!Objects.equals(this.name, index.name)) {
            return false;
        }
        if (!Objects.equals(this.expression, index.expression)) {
            return false;
        }
        if (!Objects.equals(this.regionPath, index.regionPath)) {
            return false;
        }
        return this.indexType == index.indexType;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.regionPath != null ? this.regionPath.hashCode() : 0);
        result = 31 * result + (this.indexType != null ? this.indexType.hashCode() : 0);
        return result;
    }
}

