/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.IOException;
import java.net.Socket;
import org.apache.geode.distributed.internal.tcpserver.AdvancedSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.AdvancedSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.ClientSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.ClientSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.ClusterSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.ClusterSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.ConnectionWatcher;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;

public class TcpSocketCreatorImpl
implements TcpSocketCreator {
    protected ClusterSocketCreatorImpl clusterSocketCreator;
    protected ClientSocketCreatorImpl clientSocketCreator;
    protected AdvancedSocketCreatorImpl advancedSocketCreator;

    public TcpSocketCreatorImpl() {
        this.initializeCreators();
    }

    protected void initializeCreators() {
        this.clusterSocketCreator = new ClusterSocketCreatorImpl(this);
        this.clientSocketCreator = new ClientSocketCreatorImpl(this);
        this.advancedSocketCreator = new AdvancedSocketCreatorImpl(this);
    }

    protected boolean useSSL() {
        return false;
    }

    Socket connect(HostAndPort addr, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide, int socketBufferSize) throws IOException {
        return this.connect(addr, timeout, optionalWatcher, clientSide, socketBufferSize, TcpSocketFactory.DEFAULT);
    }

    Socket connect(HostAndPort addr, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide, int socketBufferSize, TcpSocketFactory proxySocketFactory) throws IOException {
        return this.forAdvancedUse().connect(addr, timeout, optionalWatcher, clientSide, socketBufferSize, this.useSSL(), proxySocketFactory);
    }

    @Override
    public ClusterSocketCreator forCluster() {
        return this.clusterSocketCreator;
    }

    @Override
    public ClientSocketCreator forClient() {
        return this.clientSocketCreator;
    }

    @Override
    public AdvancedSocketCreator forAdvancedUse() {
        return this.advancedSocketCreator;
    }
}

