/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.AbstractCloseableIOIterator;
import com.healthmarketscience.rmiio.IOIterator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOIteratorPipe<DataType> {
    public static final int DEFAULT_QUEUE_SIZE = 100;
    private static final Object NULL_OBJECT = new Object();
    private static final Object FINAL_OBJECT = new Object();
    private boolean _sinkFinished;
    private boolean _sourceClosed;
    private final BlockingQueue<Object> _queue;
    private final Sink _sink;
    private final Source _source;

    public IOIteratorPipe() {
        this(100);
    }

    public IOIteratorPipe(int queueSize) {
        this._queue = new LinkedBlockingQueue<Object>(queueSize);
        this._sink = new Sink();
        this._source = new Source();
    }

    public Sink getSink() {
        return this._sink;
    }

    public Source getSource() {
        return this._source;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Source
    extends AbstractCloseableIOIterator<DataType> {
        private Object _next;

        private Source() {
        }

        private void getNext() throws IOException {
            try {
                this._next = IOIteratorPipe.this._queue.take();
                if (this._next == FINAL_OBJECT && !IOIteratorPipe.this._sinkFinished) {
                    throw new IOException("Sink closed abnormally");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this._next == null) {
                this.getNext();
            }
            return this._next != FINAL_OBJECT;
        }

        @Override
        protected DataType nextImpl() throws IOException {
            Object cur = this._next;
            this.getNext();
            if (cur == NULL_OBJECT) {
                cur = null;
            }
            return cur;
        }

        @Override
        protected void closeImpl() {
            IOIteratorPipe.this._sourceClosed = true;
            IOIteratorPipe.this._queue.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Sink
    implements Closeable {
        private Sink() {
        }

        private void addNextImpl(Object data) throws IOException {
            if (data == null) {
                data = NULL_OBJECT;
            }
            try {
                IOIteratorPipe.this._queue.put(data);
                if (data != FINAL_OBJECT && IOIteratorPipe.this._sourceClosed) {
                    throw new IOException("Source closed abnormally");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }

        public void addNext(DataType data) throws IOException {
            this.addNextImpl(data);
        }

        public void setFinished() throws IOException {
            IOIteratorPipe.this._sinkFinished = true;
            this.addNextImpl(FINAL_OBJECT);
        }

        @Override
        public void close() throws IOException {
            if (!IOIteratorPipe.this._sinkFinished) {
                IOIteratorPipe.this._queue.clear();
            }
            this.addNextImpl(FINAL_OBJECT);
        }

        public void addAll(IOIterator<DataType> srcIter) throws IOException {
            while (srcIter.hasNext()) {
                this.addNext(srcIter.next());
            }
            this.setFinished();
        }
    }
}

