/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.AbstractCloseableIOIterator;
import com.healthmarketscience.rmiio.CloseableIOIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiioUtil {
    private static final Log LOG = LogFactory.getLog(RmiioUtil.class);

    private RmiioUtil() {
    }

    public static <T> CloseableIOIterator<T> adapt(Iterator<? extends T> iter) {
        if (iter == null) {
            return null;
        }
        return new IOIteratorAdapter<T>(iter);
    }

    public static void closeQuietly(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"Failed closing closeable", (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IOIteratorAdapter<DataType>
    extends AbstractCloseableIOIterator<DataType> {
        private final Iterator<? extends DataType> _iter;

        public IOIteratorAdapter(Iterator<? extends DataType> iter) {
            this._iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        protected DataType nextImpl() {
            return this._iter.next();
        }

        @Override
        protected void closeImpl() {
            if (this._iter instanceof Closeable) {
                RmiioUtil.closeQuietly((Closeable)((Object)this._iter));
            }
        }
    }
}

