/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio.util;

import com.healthmarketscience.rmiio.PacketInputStream;
import com.healthmarketscience.rmiio.PacketOutputStream;
import com.healthmarketscience.rmiio.util.SingleByteAdapter;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.LinkedList;

public class PipeBuffer {
    public static final int DEFAULT_PACKET_SIZE = 1024;
    private final int _packetSize;
    private long _totalBytes;
    private final LinkedList<ByteWrapper> _buffers = new LinkedList();
    private boolean _gotReadEOF;
    private boolean _gotWriteEOF;

    public PipeBuffer() {
        this(1024);
    }

    public PipeBuffer(int packetSize) {
        this._packetSize = packetSize;
    }

    public boolean isReadClosed() {
        return this._gotReadEOF;
    }

    public void closeRead() {
        this._gotReadEOF = true;
    }

    public boolean isWriteClosed() {
        return this._gotWriteEOF;
    }

    public void closeWrite() {
        this._gotWriteEOF = true;
    }

    public int getPacketSize() {
        return this._packetSize;
    }

    public boolean hasRemaining() {
        return this._totalBytes > 0L;
    }

    public long remaining() {
        return this._totalBytes;
    }

    private void addLast(ByteWrapper bb) {
        this._buffers.addLast(bb);
    }

    private void removeFirst(boolean canKeep) {
        if (!canKeep || this._buffers.size() != 1 || this._buffers.getFirst().capacity() < this._packetSize) {
            this._buffers.removeFirst();
        } else {
            this._buffers.getFirst().clear();
        }
    }

    public byte[] readPacket() {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        ByteWrapper bb = this._buffers.getFirst();
        boolean canKeep = false;
        byte[] packet = null;
        if (bb.isFullToCapacity()) {
            packet = bb.array();
        } else {
            packet = new byte[bb.readRemaining()];
            bb.read(packet, 0, packet.length);
            canKeep = true;
        }
        this.removeFirst(canKeep);
        this._totalBytes -= (long)packet.length;
        return packet;
    }

    public void read(byte[] buf, int pos, int len) {
        if (this._totalBytes < (long)len) {
            throw new BufferUnderflowException();
        }
        PipeBuffer.checkPositionAndLength(pos, len, buf);
        int origLen = len;
        while (len > 0) {
            ByteWrapper bb = this._buffers.getFirst();
            int numBytes = bb.read(buf, pos, len);
            pos += numBytes;
            len -= numBytes;
            if (bb.hasReadRemaining()) continue;
            this.removeFirst(true);
        }
        this._totalBytes -= (long)origLen;
    }

    public void skip(long len) {
        if (this._totalBytes < len) {
            throw new BufferUnderflowException();
        }
        if (len < 0L) {
            throw new IllegalArgumentException("bogus length given");
        }
        long origLen = len;
        while (len > 0L) {
            ByteWrapper bb = this._buffers.getFirst();
            long numBytes = bb.skip(len);
            len -= numBytes;
            if (bb.hasReadRemaining()) continue;
            this.removeFirst(true);
        }
        this._totalBytes -= origLen;
    }

    public void writePacket(byte[] buf, int pos, int len) {
        PipeBuffer.checkPositionAndLength(pos, len, buf);
        if (len > 0) {
            if (this._totalBytes == 0L && this._buffers.size() > 0) {
                this._buffers.clear();
            }
            this.addLast(new ByteWrapper(buf, pos, pos + len));
            this._totalBytes += (long)len;
        }
    }

    public void write(byte[] buf, int pos, int len) {
        PipeBuffer.checkPositionAndLength(pos, len, buf);
        int origLen = len;
        while (len > 0) {
            if (this._buffers.isEmpty() || !this._buffers.getLast().hasWriteRemaining()) {
                this.addLast(new ByteWrapper(Math.max(this._packetSize, len)));
            }
            ByteWrapper bb = this._buffers.getLast();
            int numBytes = bb.write(buf, pos, len);
            pos += numBytes;
            len -= numBytes;
        }
        this._totalBytes += (long)origLen;
    }

    public void clear() {
        this._totalBytes = 0L;
        this._buffers.clear();
    }

    public int packetsAvailable() {
        return this._buffers.size() > 0 ? (this._buffers.getLast().isFullPacket(this._packetSize) ? this._buffers.size() : this._buffers.size() - 1) : 0;
    }

    private static void checkPositionAndLength(int pos, int len, byte[] buf) {
        if (pos < 0 || len < 0 || pos + len > buf.length) {
            throw new IllegalArgumentException("bogus position or length given");
        }
    }

    public static class OutputStreamAdapter
    extends PacketOutputStream {
        private SingleByteAdapter _singleByteAdapter = new SingleByteAdapter();
        private PipeBuffer _buffer;
        private boolean _throwOnReadClose;

        public OutputStreamAdapter() {
            this(false);
        }

        public OutputStreamAdapter(boolean throwOnReadClose) {
            this._throwOnReadClose = throwOnReadClose;
        }

        public PipeBuffer getBuffer() {
            return this._buffer;
        }

        public void setBuffer(PipeBuffer newBuffer) {
            this._buffer = newBuffer;
        }

        public boolean getThrowOnReadClose() {
            return this._throwOnReadClose;
        }

        public void setThrowOnReadClose(boolean newThrowOnReadClose) {
            this._throwOnReadClose = newThrowOnReadClose;
        }

        public void connect(InputStreamAdapter istream) throws IOException {
            istream.connect(this);
        }

        public void close() {
            this._buffer.closeWrite();
        }

        public void write(int b) throws IOException {
            this._singleByteAdapter.write(b, this);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int pos, int len) throws IOException {
            if (this._buffer.isReadClosed()) {
                this.handleReadClosed();
                return;
            }
            this._buffer.write(b, pos, len);
        }

        public void writePacket(byte[] packet) throws IOException {
            if (this._buffer.isReadClosed()) {
                this.handleReadClosed();
                return;
            }
            this._buffer.writePacket(packet, 0, packet.length);
        }

        private void handleReadClosed() throws IOException {
            if (this._throwOnReadClose) {
                throw new IOException("Reader is no longer reading");
            }
        }
    }

    public static class InputStreamAdapter
    extends PacketInputStream {
        private SingleByteAdapter _singleByteAdapter = new SingleByteAdapter();
        private PipeBuffer _buffer;

        public InputStreamAdapter() {
            this(1024);
        }

        public InputStreamAdapter(int packetSize) {
            super(packetSize);
        }

        public PipeBuffer getBuffer() {
            return this._buffer;
        }

        public void setBuffer(PipeBuffer newBuffer) {
            this._buffer = newBuffer;
        }

        public PipeBuffer createPipeBuffer() {
            if (this._buffer == null) {
                this._buffer = new PipeBuffer(this.getPacketSize());
            }
            return this._buffer;
        }

        public void connect(OutputStreamAdapter ostream) throws IOException {
            if (ostream.getBuffer() != null && this.getBuffer() != null && ostream.getBuffer() != this.getBuffer()) {
                throw new IOException("Source and sink are already connected to other PipeBuffers");
            }
            PipeBuffer pipeBuffer = ostream.getBuffer();
            if (pipeBuffer == null) {
                pipeBuffer = this.getBuffer();
            }
            if (pipeBuffer == null) {
                pipeBuffer = this.createPipeBuffer();
            }
            ostream.setBuffer(pipeBuffer);
            this.setBuffer(pipeBuffer);
        }

        public void close() {
            this._buffer.closeRead();
        }

        public int available() throws IOException {
            return (int)this._buffer.remaining();
        }

        public int read() throws IOException {
            if (!this._buffer.hasRemaining() && !this._buffer.isWriteClosed()) {
                throw new IOException("Cannot call this method with no bytes in the PipeBuffer");
            }
            return this._singleByteAdapter.read(this);
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] buf, int pos, int len) throws IOException {
            if (this.isFinished()) {
                return -1;
            }
            int numBytes = Math.min(len, (int)this._buffer.remaining());
            this._buffer.read(buf, pos, numBytes);
            return numBytes;
        }

        public byte[] readPacket(boolean readPartial) throws IOException {
            if (this.isFinished()) {
                return null;
            }
            return this._buffer.readPacket();
        }

        public int packetsAvailable() throws IOException {
            return this._buffer.packetsAvailable();
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            long toSkip = Math.min(n, this._buffer.remaining());
            this._buffer.skip(toSkip);
            return toSkip;
        }

        private boolean isFinished() {
            return !this._buffer.hasRemaining() && this._buffer.isWriteClosed();
        }
    }

    private static class ByteWrapper {
        private int _readPosition;
        private int _writePosition;
        private byte[] _buf;

        private ByteWrapper(int size) {
            this(new byte[size], 0, 0);
        }

        private ByteWrapper(byte[] buf, int readPosition, int writePosition) {
            this._buf = buf;
            this._readPosition = readPosition;
            this._writePosition = writePosition;
        }

        public int capacity() {
            return this._buf.length;
        }

        public byte[] array() {
            return this._buf;
        }

        public int write(byte[] b, int pos, int len) {
            int numBytes = Math.min(this.writeRemaining(), len);
            System.arraycopy(b, pos, this._buf, this._writePosition, numBytes);
            this._writePosition += numBytes;
            return numBytes;
        }

        public long skip(long len) {
            long numBytes = Math.min((long)this.readRemaining(), len);
            this._readPosition += (int)numBytes;
            return numBytes;
        }

        public int read(byte[] b, int pos, int len) {
            int numBytes = Math.min(this.readRemaining(), len);
            System.arraycopy(this._buf, this._readPosition, b, pos, numBytes);
            this._readPosition += numBytes;
            return numBytes;
        }

        public boolean hasWriteRemaining() {
            return this.writeRemaining() > 0;
        }

        public int writeRemaining() {
            return this._buf.length - this._writePosition;
        }

        public boolean hasReadRemaining() {
            return this.readRemaining() > 0;
        }

        public int readRemaining() {
            return this._writePosition - this._readPosition;
        }

        public boolean isFullToCapacity() {
            return this.readRemaining() == this._buf.length;
        }

        public boolean isFullPacket(int packetSize) {
            return !this.hasWriteRemaining() || this.readRemaining() >= packetSize;
        }

        public void clear() {
            this._writePosition = 0;
            this._readPosition = 0;
        }
    }
}

