/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.GemFireMemberStatus;
import org.apache.geode.admin.RegionSubRegionSnapshot;
import org.apache.geode.admin.internal.AbstractHealthEvaluator;
import org.apache.geode.admin.internal.DistributedSystemHealthEvaluator;
import org.apache.geode.admin.internal.GemFireHealthImpl;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.Config;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.DLockInfo;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.admin.HealthListener;
import org.apache.geode.internal.admin.Stat;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.StatListener;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
class DistributedSystemHealthMonitor
implements Runnable,
GemFireVM {
    private static final Logger logger = LogService.getLogger();
    private final DistributedSystemHealthEvaluator eval;
    private final GemFireHealthImpl healthImpl;
    private final int interval;
    private final Thread thread;
    private volatile boolean stopRequested = false;
    private GemFireHealth.Health prevHealth = GemFireHealth.GOOD_HEALTH;
    private final List<String> okayDiagnoses;
    private final List<String> poorDiagnoses;

    DistributedSystemHealthMonitor(DistributedSystemHealthEvaluator eval, GemFireHealthImpl healthImpl, int interval) {
        this.eval = eval;
        this.healthImpl = healthImpl;
        this.interval = interval;
        this.okayDiagnoses = new ArrayList<String>();
        this.poorDiagnoses = new ArrayList<String>();
        String name = String.format("Health monitor for %s", eval.getDescription());
        this.thread = new LoggingThread(name, (Runnable)this);
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug("Monitoring health of {} every {} seconds", (Object)this.eval.getDescription(), (Object)this.interval);
        }
        while (!this.stopRequested) {
            SystemFailure.checkFailure();
            try {
                Thread.sleep((long)this.interval * 1000L);
                ArrayList<AbstractHealthEvaluator.HealthStatus> status = new ArrayList<AbstractHealthEvaluator.HealthStatus>();
                this.eval.evaluate(status);
                GemFireHealth.Health overallHealth = GemFireHealth.GOOD_HEALTH;
                this.okayDiagnoses.clear();
                this.poorDiagnoses.clear();
                for (Object e : status) {
                    GemFireHealth.Health healthCode;
                    AbstractHealthEvaluator.HealthStatus health = (AbstractHealthEvaluator.HealthStatus)e;
                    if (overallHealth == GemFireHealth.GOOD_HEALTH) {
                        if (health.getHealthCode() != GemFireHealth.GOOD_HEALTH) {
                            overallHealth = health.getHealthCode();
                        }
                    } else if (overallHealth == GemFireHealth.OKAY_HEALTH && health.getHealthCode() == GemFireHealth.POOR_HEALTH) {
                        overallHealth = GemFireHealth.POOR_HEALTH;
                    }
                    if ((healthCode = health.getHealthCode()) == GemFireHealth.OKAY_HEALTH) {
                        this.okayDiagnoses.add(health.getDiagnosis());
                        continue;
                    }
                    if (healthCode != GemFireHealth.POOR_HEALTH) continue;
                    this.poorDiagnoses.add(health.getDiagnosis());
                    break;
                }
                if (overallHealth == this.prevHealth) continue;
                this.healthImpl.healthChanged(this, overallHealth);
                this.prevHealth = overallHealth;
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        this.eval.close();
        if (logger.isDebugEnabled()) {
            logger.debug("Stopped checking for distributed system health");
        }
    }

    void start() {
        this.thread.start();
    }

    void stop() {
        if (this.thread.isAlive()) {
            this.stopRequested = true;
            this.thread.interrupt();
            this.healthImpl.nodeLeft(null, this);
            try {
                this.thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted while stopping health monitor thread", (Throwable)ex);
            }
        }
    }

    @Override
    public InetAddress getHost() {
        try {
            return LocalHostUtil.getLocalHost();
        }
        catch (Exception ex) {
            throw new InternalGemFireException("Could not get localhost?!");
        }
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public File getWorkingDirectory() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public File getGeodeHomeDir() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public Date getBirthDate() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    public Properties getLicenseInfo() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public GemFireMemberStatus getSnapshot() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public RegionSubRegionSnapshot getRegionSnapshot() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public StatResource[] getStats(String statisticsTypeName) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public StatResource[] getAllStats() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public DLockInfo[] getDistributedLockInfo() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void addStatListener(StatListener observer, StatResource observedResource, Stat observedStat) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void removeStatListener(StatListener observer) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void addHealthListener(HealthListener observer, GemFireHealthConfig cfg) {
    }

    @Override
    public void removeHealthListener() {
    }

    @Override
    public void resetHealthStatus() {
        this.prevHealth = GemFireHealth.GOOD_HEALTH;
    }

    @Override
    public String[] getHealthDiagnosis(GemFireHealth.Health healthCode) {
        if (healthCode == GemFireHealth.GOOD_HEALTH) {
            return new String[0];
        }
        if (healthCode == GemFireHealth.OKAY_HEALTH) {
            String[] array = new String[this.okayDiagnoses.size()];
            this.okayDiagnoses.toArray(array);
            return array;
        }
        Assert.assertTrue(healthCode == GemFireHealth.POOR_HEALTH);
        String[] array = new String[this.poorDiagnoses.size()];
        this.poorDiagnoses.toArray(array);
        return array;
    }

    @Override
    public Config getConfig() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void setConfig(Config cfg) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public GfManagerAgent getManagerAgent() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public String[] getSystemLogs() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void setInspectionClasspath(String classpath) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public String getInspectionClasspath() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public Region[] getRootRegions() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public Region getRegion(CacheInfo c, String path) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public Region createVMRootRegion(CacheInfo c, String name, RegionAttributes attrs) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public Region createSubregion(CacheInfo c, String parentPath, String name, RegionAttributes attrs) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void setCacheInspectionMode(int mode) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public int getCacheInspectionMode() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void takeRegionSnapshot(String regionName, int snapshotId) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public InternalDistributedMember getId() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public CacheInfo getCacheInfo() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public String getVersionInfo() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public CacheInfo setCacheLockTimeout(CacheInfo c, int v) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public CacheInfo setCacheLockLease(CacheInfo c, int v) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public CacheInfo setCacheSearchTimeout(CacheInfo c, int v) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public AdminBridgeServer addCacheServer(CacheInfo cache) throws AdminException {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public AdminBridgeServer getBridgeInfo(CacheInfo cache, int id) throws AdminException {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public AdminBridgeServer startBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public AdminBridgeServer stopBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void setAlertsManager(StatAlertDefinition[] alertDefs, long refreshInterval, boolean setRemotely) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void setRefreshInterval(long refreshInterval) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public void updateAlertDefinitions(StatAlertDefinition[] alertDefs, int actionCode) {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }
}

