/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.CacheDoesNotExistException;
import org.apache.geode.admin.GemFireMemberStatus;
import org.apache.geode.admin.RegionSubRegionSnapshot;
import org.apache.geode.admin.Statistic;
import org.apache.geode.admin.SystemMemberBridgeServer;
import org.apache.geode.admin.SystemMemberCache;
import org.apache.geode.admin.SystemMemberCacheServer;
import org.apache.geode.admin.SystemMemberRegion;
import org.apache.geode.admin.internal.StatisticImpl;
import org.apache.geode.admin.internal.SystemMemberBridgeServerImpl;
import org.apache.geode.admin.internal.SystemMemberRegionImpl;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ObjIdMap;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.Stat;
import org.apache.geode.internal.admin.StatResource;

@Deprecated
public class SystemMemberCacheImpl
implements SystemMemberCache {
    protected final GemFireVM vm;
    protected CacheInfo info;
    protected Statistic[] statistics;
    private final ObjIdMap bridgeServers = new ObjIdMap();

    public SystemMemberCacheImpl(GemFireVM vm) throws CacheDoesNotExistException {
        this.vm = vm;
        this.info = vm.getCacheInfo();
        if (this.info == null) {
            throw new CacheDoesNotExistException(String.format("The VM %s does not currently have a cache.", vm.getId()));
        }
        this.initStats();
    }

    @Override
    public String getName() {
        String result = this.info.getName();
        if (result == null || result.length() == 0) {
            result = "default";
        }
        return result;
    }

    @Override
    public int getId() {
        return this.info.getId();
    }

    @Override
    public boolean isClosed() {
        return this.info.isClosed();
    }

    @Override
    public int getLockTimeout() {
        return this.info.getLockTimeout();
    }

    @Override
    public void setLockTimeout(int seconds) throws AdminException {
        this.info = this.vm.setCacheLockTimeout(this.info, seconds);
    }

    @Override
    public int getLockLease() {
        return this.info.getLockLease();
    }

    @Override
    public void setLockLease(int seconds) throws AdminException {
        this.info = this.vm.setCacheLockLease(this.info, seconds);
    }

    @Override
    public int getSearchTimeout() {
        return this.info.getSearchTimeout();
    }

    @Override
    public void setSearchTimeout(int seconds) throws AdminException {
        this.info = this.vm.setCacheSearchTimeout(this.info, seconds);
    }

    @Override
    public int getUpTime() {
        return this.info.getUpTime();
    }

    @Override
    public Set getRootRegionNames() {
        Set set = this.info.getRootRegionNames();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    @Override
    public void refresh() {
        if (!this.info.isClosed()) {
            CacheInfo cur = this.vm.getCacheInfo();
            if (cur == null || this.info.getId() != cur.getId()) {
                this.info.setClosed();
            } else {
                this.info = cur;
                this.updateStats();
            }
        }
    }

    public GemFireMemberStatus getSnapshot() {
        GemFireMemberStatus stat = this.vm.getSnapshot();
        return stat;
    }

    public RegionSubRegionSnapshot getRegionSnapshot() {
        RegionSubRegionSnapshot snap = this.vm.getRegionSnapshot();
        return snap;
    }

    @Override
    public Statistic[] getStatistics() {
        return this.statistics;
    }

    @Override
    public SystemMemberRegion getRegion(String path) throws AdminException {
        Region r = this.vm.getRegion(this.info, path);
        if (r == null) {
            return null;
        }
        return this.createSystemMemberRegion(r);
    }

    @Override
    public SystemMemberRegion createRegion(String name, RegionAttributes attrs) throws AdminException {
        Region r = this.vm.createVMRootRegion(this.info, name, attrs);
        if (r == null) {
            return null;
        }
        return this.createSystemMemberRegion(r);
    }

    @Override
    public SystemMemberRegion createVMRegion(String name, RegionAttributes attrs) throws AdminException {
        return this.createRegion(name, attrs);
    }

    private void initStats() {
        StatResource resource = this.info.getPerfStats();
        if (resource == null) {
            Assert.assertTrue(this.isClosed());
            return;
        }
        Stat[] stats = resource.getStats();
        if (stats == null || stats.length < 1) {
            this.statistics = new Statistic[0];
            return;
        }
        ArrayList<Statistic> statList = new ArrayList<Statistic>();
        for (Stat stat : stats) {
            statList.add(this.createStatistic(stat));
        }
        this.statistics = statList.toArray(new Statistic[0]);
    }

    private void updateStats() {
        StatResource resource = this.info.getPerfStats();
        if (resource == null) {
            Assert.assertTrue(this.isClosed());
            return;
        }
        Stat[] stats = resource.getStats();
        if (stats == null || stats.length < 1) {
            return;
        }
        for (Stat stat : stats) {
            this.updateStatistic(stat);
        }
    }

    private void updateStatistic(Stat stat) {
        for (Statistic statistic : this.statistics) {
            if (!statistic.getName().equals(stat.getName())) continue;
            ((StatisticImpl)statistic).setStat(stat);
            return;
        }
        Assert.assertTrue(false, "Unknown stat: " + stat.getName());
    }

    public CacheInfo getCacheInfo() {
        return this.info;
    }

    public GemFireVM getVM() {
        return this.vm;
    }

    protected Statistic createStatistic(Stat stat) {
        return new StatisticImpl(stat);
    }

    protected SystemMemberRegion createSystemMemberRegion(Region r) throws AdminException {
        SystemMemberRegionImpl sysMemberRegion = new SystemMemberRegionImpl(this, r);
        sysMemberRegion.refresh();
        return sysMemberRegion;
    }

    @Override
    public SystemMemberCacheServer addCacheServer() throws AdminException {
        AdminBridgeServer bridge = this.vm.addCacheServer(this.info);
        SystemMemberBridgeServerImpl admin = this.createSystemMemberBridgeServer(bridge);
        this.bridgeServers.put(bridge.getId(), admin);
        return admin;
    }

    private Collection getCacheServersCollection() throws AdminException {
        int[] bridgeIds;
        ArrayList<SystemMemberBridgeServer> bridges = new ArrayList<SystemMemberBridgeServer>();
        for (int id : bridgeIds = this.info.getBridgeServerIds()) {
            AdminBridgeServer info;
            SystemMemberBridgeServer bridge = (SystemMemberBridgeServer)this.bridgeServers.get(id);
            if (bridge == null && (info = this.vm.getBridgeInfo(this.info, id)) != null) {
                bridge = this.createSystemMemberBridgeServer(info);
                this.bridgeServers.put(info.getId(), bridge);
            }
            if (bridge == null) continue;
            bridges.add(bridge);
        }
        return bridges;
    }

    @Override
    public SystemMemberCacheServer[] getCacheServers() throws AdminException {
        Collection bridges = this.getCacheServersCollection();
        SystemMemberCacheServer[] array = new SystemMemberCacheServer[bridges.size()];
        return bridges.toArray(array);
    }

    protected SystemMemberBridgeServerImpl createSystemMemberBridgeServer(AdminBridgeServer bridge) throws AdminException {
        return new SystemMemberBridgeServerImpl(this, bridge);
    }

    @Override
    public boolean isServer() throws AdminException {
        return this.info.isServer();
    }

    public String toString() {
        return this.getName();
    }
}

