/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class GenerateMBeanHTML
extends DefaultHandler {
    private static final String DTD_LOCATION = "/org/apache/geode/admin/jmx/internal/doc-files/mbeans-descriptors.dtd";
    private static final String MBEANS_DESCRIPTORS = "mbeans-descriptors";
    private static final String MBEAN = "mbean";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String ATTRIBUTE = "attribute";
    private static final String WRITEABLE = "writeable";
    private static final String OPERATION = "operation";
    private static final String RETURN_TYPE = "returnType";
    private static final String PARAMETER = "parameter";
    private static final String NOTIFICATION = "notification";
    private static final String FIELD = "field";
    private static final String VALUE = "value";
    private final PrintWriter pw;
    private boolean seenAttribute = false;
    private boolean seenOperation = false;
    private boolean seenNotifications = false;
    @Immutable
    private static final PrintStream err = System.err;

    private static void convert(InputStream in, PrintWriter out) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        SAXParser parser = factory.newSAXParser();
        GenerateMBeanHTML handler = new GenerateMBeanHTML(out);
        parser.parse(in, (DefaultHandler)handler);
    }

    private GenerateMBeanHTML(PrintWriter pw) {
        this.pw = pw;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId == null || systemId == null) {
            throw new SAXException(String.format("Public Id: %s System Id: %s", publicId, systemId));
        }
        String location = DTD_LOCATION;
        InputStream stream = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), location);
        if (stream == null) {
            throw new SAXNotRecognizedException(String.format("DTD not found: %s", location));
        }
        InputSource result = new InputSource(stream);
        return result;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    private void startMBeansDescriptors() {
        this.pw.println("<HTML>");
        this.pw.println("<HEAD>");
        this.pw.println("<TITLE>GemFire MBeans Interface</TITLE>");
        this.pw.println("</HEAD>");
        this.pw.println("");
        this.pw.println("<h1>GemFire Management Beans</h1>");
        this.pw.println("");
        this.pw.println("<P>This document describes the attributes, operations,");
        this.pw.println("and notifications of the GemFire Administration");
        this.pw.println("Management Beans (MBeans).<p>");
        this.pw.println("");
    }

    private void endMBeansDescriptors() {
        this.pw.println("</HTML>");
    }

    private void startMBean(Attributes atts) {
        String name = atts.getValue(NAME);
        atts.getValue(DESCRIPTION);
        this.pw.println("<h2><b>" + name + "</b> MBean</h2>");
        this.pw.println("<table border=\"0\" cellpadding=\"3\">");
        this.pw.println("<tr valign=\"top\">");
        this.pw.println("  <th align=\"left\">Description:</th>");
        this.pw.println("  <td colspan=\"4\">GemFire distributed system</td>");
        this.pw.println("</tr>");
    }

    private void endMBean() {
        this.seenAttribute = false;
        this.seenOperation = false;
        this.seenNotifications = false;
        this.pw.println("</table>");
        this.pw.println("");
        this.pw.println("<P><p>");
        this.pw.println("");
    }

    private void startAttribute(Attributes atts) {
        if (!this.seenAttribute) {
            this.pw.println("<tr valign=\"top\">");
            this.pw.println("  <th align=\"left\">Attributes</th>");
            this.pw.println("  <th align=\"left\" colspan=\"2\">Name</th>");
            this.pw.println("  <th align=\"left\">Type</th>");
            this.pw.println("  <th align=\"left\">Description</th>");
            this.pw.println("  <th align=\"left\">Writable</th>");
            this.pw.println("</tr>");
        }
        this.seenAttribute = true;
        String name = atts.getValue(NAME);
        String description = atts.getValue(DESCRIPTION);
        String type = atts.getValue(TYPE);
        String writeable = atts.getValue(WRITEABLE);
        this.pw.println("<tr valign=\"top\">");
        this.pw.println("  <td></td>");
        this.pw.println("  <td colspan=\"2\">" + name + "</td>");
        this.pw.println("  <td>" + type + "</td>");
        this.pw.println("  <td>" + description + "</td>");
        this.pw.println("  <td>" + writeable + "</td>");
        this.pw.println("</tr>");
    }

    private void startOperation(Attributes atts) {
        if (!this.seenOperation) {
            if (!this.seenAttribute) {
                this.pw.println("<tr valign=\"top\">");
                this.pw.println("  <th align=\"left\">Operations</th>");
                this.pw.println("  <th align=\"left\" colspan=\"2\">Name</th>");
                this.pw.println("  <th align=\"left\">Type</th>");
                this.pw.println("  <th align=\"left\">Description</th>");
                this.pw.println("  <th align=\"left\"></th>");
                this.pw.println("</tr>");
            } else {
                String title = "Operations and Parameters";
                this.pw.println("<tr valign=\"top\">");
                this.pw.println("  <th align=\"left\" colspan=\"6\">" + title + "</th>");
                this.pw.println("</tr>");
            }
        }
        this.seenOperation = true;
        String name = atts.getValue(NAME);
        String type = atts.getValue(RETURN_TYPE);
        String description = atts.getValue(DESCRIPTION);
        this.pw.println("<tr valign=\"top\">");
        this.pw.println("  <td></td>");
        this.pw.println("  <td colspan=\"2\">" + name + "</td>");
        this.pw.println("  <td>" + type + "</td>");
        this.pw.println("  <td colspan=\"2\">" + description + "</td>");
        this.pw.println("</tr>");
    }

    private void startParameter(Attributes atts) {
        String name = atts.getValue(NAME);
        String description = atts.getValue(DESCRIPTION);
        String type = atts.getValue(TYPE);
        this.pw.println("<tr valign=\"top\">");
        this.pw.println("  <td></td>");
        this.pw.println("  <td width=\"10\"></td>");
        this.pw.println("  <td>" + name + "</td>");
        this.pw.println("  <td>" + type + "</td>");
        this.pw.println("  <td colspan=\"2\">" + description + "</td>");
        this.pw.println("</tr>");
    }

    private void startNotification(Attributes atts) {
        if (!this.seenNotifications) {
            if (!this.seenAttribute && !this.seenOperation) {
                this.pw.println("<tr valign=\"top\">");
                this.pw.println("  <th align=\"left\">Notifications</th>");
                this.pw.println("  <th align=\"left\" colspan=\"2\">Name</th>");
                this.pw.println("  <th align=\"left\">Type</th>");
                this.pw.println("  <th align=\"left\">Description</th>");
                this.pw.println("  <th align=\"left\"></th>");
                this.pw.println("</tr>");
                this.pw.println("</tr>");
            } else {
                this.pw.println("<tr valign=\"top\">");
                this.pw.println("  <th align=\"left\" colspan=\"6\">Notifications and Fields</th>");
                this.pw.println("</tr>");
            }
        }
        this.seenNotifications = true;
        String name = atts.getValue(NAME);
        String description = atts.getValue(DESCRIPTION);
        this.pw.println("<tr valign=\"top\">");
        this.pw.println("  <td></td>");
        this.pw.println("  <td colspan=\"3\">" + name + "</td>");
        this.pw.println("  <td colspan=\"3\">" + description + "</td>");
        this.pw.println("</tr>");
    }

    private void startField(Attributes atts) {
        String name = atts.getValue(NAME);
        String value = atts.getValue(VALUE);
        this.pw.println("<tr valign=\"top\">");
        this.pw.println("  <td></td>");
        this.pw.println("  <td width=\"10\"></td>");
        this.pw.println("  <td colspan=\"2\">" + name + "</td>");
        this.pw.println("  <td colspan=\"2\">" + value + "</td>");
        this.pw.println("</tr>");
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(MBEANS_DESCRIPTORS)) {
            this.startMBeansDescriptors();
        } else if (qName.equals(MBEAN)) {
            this.startMBean(atts);
        } else if (qName.equals(ATTRIBUTE)) {
            this.startAttribute(atts);
        } else if (qName.equals(OPERATION)) {
            this.startOperation(atts);
        } else if (qName.equals(PARAMETER)) {
            this.startParameter(atts);
        } else if (qName.equals(NOTIFICATION)) {
            this.startNotification(atts);
        } else if (qName.equals(FIELD)) {
            this.startField(atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals(MBEANS_DESCRIPTORS)) {
            this.endMBeansDescriptors();
        } else if (qName.equals(MBEAN)) {
            this.endMBean();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: java GenerateMBeanHTML xmlFile htmlFile");
        err.println();
        err.println("Converts an MBeans description XML file into an HTML");
        err.println("file suitable for documentation");
        err.println();
        ExitCode.FATAL.doSystemExit();
    }

    public static void main(String[] args) throws Exception {
        String xmlFileName = null;
        String htmlFileName = null;
        for (String arg : args) {
            if (xmlFileName == null) {
                xmlFileName = arg;
                continue;
            }
            if (htmlFileName == null) {
                htmlFileName = arg;
                continue;
            }
            GenerateMBeanHTML.usage("Extraneous command line argument: " + arg);
        }
        if (xmlFileName == null) {
            GenerateMBeanHTML.usage("Missing XML file name");
        } else if (htmlFileName == null) {
            GenerateMBeanHTML.usage("Missing HTML file name");
        }
        File xmlFile = new File(xmlFileName);
        if (!xmlFile.exists()) {
            GenerateMBeanHTML.usage("XML file \"" + xmlFile + "\" does not exist");
        }
        File htmlFile = new File(htmlFileName);
        try (FileInputStream fileInputStream = new FileInputStream(xmlFile);
             FileWriter fileWriter = new FileWriter(htmlFile);
             PrintWriter printWriter = new PrintWriter((Writer)fileWriter, true);){
            GenerateMBeanHTML.convert(fileInputStream, printWriter);
        }
    }
}

