/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal.spi;

import org.apache.geode.logging.internal.spi.LogWriterLevel;

public enum AlertLevel {
    WARNING(LogWriterLevel.WARNING.intLevel()),
    ERROR(LogWriterLevel.ERROR.intLevel()),
    SEVERE(LogWriterLevel.SEVERE.intLevel()),
    NONE(LogWriterLevel.NONE.intLevel());

    private final int intLevel;

    public static AlertLevel find(int intLevel) {
        for (AlertLevel alertLevel : AlertLevel.values()) {
            if (alertLevel.intLevel != intLevel) continue;
            return alertLevel;
        }
        throw new IllegalArgumentException("No AlertLevel found for intLevel " + intLevel);
    }

    private AlertLevel(int intLevel) {
        this.intLevel = intLevel;
    }

    public int intLevel() {
        return this.intLevel;
    }

    public boolean meetsOrExceeds(AlertLevel alertLevel) {
        return this.intLevel() < alertLevel.intLevel();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name() + "(" + this.intLevel + ")";
    }
}

