/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.List;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.jetbrains.annotations.NotNull;

public class PrimaryAckOp {
    public static void execute(Connection connection, ExecutablePool pool, List events) {
        PrimaryAckOpImpl op = new PrimaryAckOpImpl(events);
        pool.executeOn(connection, (Op)op);
    }

    private PrimaryAckOp() {
    }

    private static class PrimaryAckOpImpl
    extends AbstractOp {
        public PrimaryAckOpImpl(List events) {
            super(52, events.size());
            for (Object event : events) {
                this.getMessage().addObjPart(event);
            }
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(@NotNull Message msg) throws Exception {
            this.processAck(msg, "primaryAck");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startPrimaryAck();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endPrimaryAckSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endPrimaryAck(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

