/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.examples.security;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.query.security.MethodInvocationAuthorizer;
import org.apache.geode.cache.query.security.RestrictedMethodAuthorizer;

public class ExampleAnnotationBasedMethodInvocationAuthorizer
implements MethodInvocationAuthorizer {
    private RestrictedMethodAuthorizer defaultAuthorizer;

    @Override
    public void initialize(Cache cache, Set<String> parameters) {
        this.defaultAuthorizer = new RestrictedMethodAuthorizer(cache);
    }

    @Override
    public boolean authorize(Method method, Object target) {
        if (this.defaultAuthorizer.isPermanentlyForbiddenMethod(method, target)) {
            return false;
        }
        return method.isAnnotationPresent(Authorized.class);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Authorized {
    }
}

