/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.CacheSnapshot;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;
import org.apache.geode.internal.admin.remote.RemoteRegionSnapshot;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class SnapshotResultMessage
extends PooledDistributionMessage
implements AdminMessageType {
    private CacheSnapshot results;
    private int snapshotId;

    public static SnapshotResultMessage create(Region region, int snapshotId) throws CacheException {
        SnapshotResultMessage m = new SnapshotResultMessage();
        m.results = new RemoteRegionSnapshot(region);
        m.snapshotId = snapshotId;
        return m;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        RemoteGfManagerAgent agent = dm.getAgent();
        if (agent != null) {
            agent.enqueueSnapshotResults(this);
        }
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public CacheSnapshot getSnapshot() {
        return this.results;
    }

    public int getSnapshotId() {
        return this.snapshotId;
    }

    public int getDSFID() {
        return 1055;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.results, out);
        out.writeInt(this.snapshotId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.results = (CacheSnapshot)DataSerializer.readObject(in);
        this.snapshotId = in.readInt();
    }
}

