/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VMStatsDiskLRURegionEntry;
import org.apache.geode.internal.cache.entries.VMStatsDiskLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VMStatsDiskLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VMStatsDiskLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VMStatsDiskLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VMStatsDiskLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VMStatsDiskLRURegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntryHeap;

public abstract class VMStatsDiskLRURegionEntryHeap
extends VMStatsDiskLRURegionEntry {
    @Immutable
    private static final VMStatsDiskLRURegionEntryHeapFactory factory = new VMStatsDiskLRURegionEntryHeapFactory();

    public VMStatsDiskLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsDiskLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsDiskLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMStatsDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

