/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.event;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.cache.versions.VersionTag;

public class EventSequenceNumberHolder
implements DataSerializable {
    private static final long serialVersionUID = 8137262960763308046L;
    private long lastSequenceNumber = -1L;
    private transient long endOfLifeTimestamp;
    private transient boolean removed;
    private VersionTag versionTag;

    EventSequenceNumberHolder(long id, VersionTag versionTag) {
        this.lastSequenceNumber = id;
        this.versionTag = versionTag;
    }

    public EventSequenceNumberHolder() {
    }

    public long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved(boolean removed) {
        this.removed = removed;
    }

    void setEndOfLifeTimestamp(long endOfLifeTimestamp) {
        this.endOfLifeTimestamp = endOfLifeTimestamp;
    }

    void setVersionTag(VersionTag versionTag) {
        this.versionTag = versionTag;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("seqNo").append(this.lastSequenceNumber);
        if (this.versionTag != null) {
            result.append(",").append(this.versionTag);
        }
        return result.toString();
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.lastSequenceNumber = in.readLong();
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.lastSequenceNumber);
        DataSerializer.writeObject(this.versionTag, out);
    }

    public synchronized boolean expire(long now, long expirationTime) {
        if (this.endOfLifeTimestamp == 0L) {
            this.endOfLifeTimestamp = now;
        }
        boolean expire = false;
        if (this.endOfLifeTimestamp <= expirationTime) {
            this.removed = true;
            this.lastSequenceNumber = -1L;
            expire = true;
        }
        return expire;
    }

    public void setLastSequenceNumber(long lastSequenceNumber) {
        this.lastSequenceNumber = lastSequenceNumber;
    }
}

