/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.eviction.SizeLRUController;
import org.apache.geode.internal.cache.persistence.DiskRegionView;

public class HeapLRUController
extends SizeLRUController {
    public static final String TOP_UP_HEAP_EVICTION_PERCENTAGE_PROPERTY = "gemfire.topUpHeapEvictionPercentage";

    public HeapLRUController(EvictionCounters evictionCounters, EvictionAction evictionAction, ObjectSizer sizer, EvictionAlgorithm algorithm) {
        super(evictionCounters, evictionAction, sizer, algorithm);
    }

    @Override
    public void setLimit(int maximum) {
    }

    @Override
    public long getLimit() {
        return 0L;
    }

    @Override
    public String toString() {
        return String.format("HeapLRUCapacityController with a capacity of %s%s of memory and eviction action %s.", this.getLimit(), "%", this.getEvictionAction());
    }

    @Override
    public int entrySize(Object key, Object value) {
        if (value == Token.TOMBSTONE) {
            return 0;
        }
        int size = this.getPerEntryOverhead();
        size += this.sizeof(key);
        return size += this.sizeof(value);
    }

    @Override
    public boolean mustEvict(EvictionCounters stats, InternalRegion region, int delta) {
        InternalCache cache = (InternalCache)region.getRegionService();
        boolean offheap = region.getAttributes().getOffHeap();
        boolean shouldEvict = cache.getInternalResourceManager().getMemoryMonitor(offheap).getState().isEviction();
        if (region instanceof BucketRegion) {
            return shouldEvict && ((BucketRegion)region).getSizeForEviction() > 0;
        }
        return shouldEvict && region.getRegionMap().sizeInVM() > 0;
    }

    @Override
    public boolean lruLimitExceeded(EvictionCounters stats, DiskRegionView diskRegionView) {
        InternalResourceManager resourceManager = diskRegionView.getDiskStore().getCache().getInternalResourceManager();
        return resourceManager.getMemoryMonitor(diskRegionView.getOffHeap()).getState().isEviction();
    }
}

