/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AllBucketProfilesUpdateMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private int prId;
    private int processorId = 0;
    private Map<Integer, BucketAdvisor.BucketProfile> profiles;

    public AllBucketProfilesUpdateMessage() {
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    private AllBucketProfilesUpdateMessage(Set recipients, int partitionedRegionId, int processorId, Map<Integer, BucketAdvisor.BucketProfile> profiles) {
        this.setRecipients(recipients);
        this.processorId = processorId;
        this.prId = partitionedRegionId;
        this.profiles = profiles;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        try {
            PartitionedRegion pr = PartitionedRegion.getPRFromId(this.prId);
            for (Map.Entry<Integer, BucketAdvisor.BucketProfile> profile : this.profiles.entrySet()) {
                pr.getRegionAdvisor().putBucketProfile(profile.getKey(), profile.getValue());
            }
        }
        catch (PRLocallyDestroyedException fre) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region locally destroyed> ///{}", (Object)this);
            }
        }
        catch (RegionDestroyedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region destroyed> ///{}", (Object)this);
            }
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<cache closed> ///{}", (Object)this);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ignore) {
            SystemFailure.checkFailure();
        }
        finally {
            if (this.processorId != 0) {
                ReplyMessage.send(this.getSender(), this.processorId, null, (ReplySender)dm);
            }
        }
    }

    public static ReplyProcessor21 send(Set recipients, DistributionManager dm, int prId, Map<Integer, BucketAdvisor.BucketProfile> profiles) {
        if (recipients.isEmpty()) {
            return null;
        }
        ReplyProcessor21 rp = null;
        int procId = 0;
        rp = new ReplyProcessor21(dm, (Collection)recipients);
        procId = rp.getProcessorId();
        AllBucketProfilesUpdateMessage m = new AllBucketProfilesUpdateMessage(recipients, prId, procId, profiles);
        dm.putOutgoing(m);
        return rp;
    }

    public int getDSFID() {
        return 2124;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.prId = in.readInt();
        this.processorId = in.readInt();
        this.profiles = (Map)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.prId);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.profiles, out);
    }
}

