/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.CommandRegistry;
import org.apache.geode.internal.cache.tier.sockets.command.AddPdxEnum;
import org.apache.geode.internal.cache.tier.sockets.command.AddPdxType;
import org.apache.geode.internal.cache.tier.sockets.command.ClearRegion;
import org.apache.geode.internal.cache.tier.sockets.command.ClientReady;
import org.apache.geode.internal.cache.tier.sockets.command.CloseConnection;
import org.apache.geode.internal.cache.tier.sockets.command.CommitCommand;
import org.apache.geode.internal.cache.tier.sockets.command.ContainsKey66;
import org.apache.geode.internal.cache.tier.sockets.command.CreateRegion;
import org.apache.geode.internal.cache.tier.sockets.command.Destroy70;
import org.apache.geode.internal.cache.tier.sockets.command.DestroyRegion;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteFunction70;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteRegionFunction66;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteRegionFunctionGeode18;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteRegionFunctionSingleHop;
import org.apache.geode.internal.cache.tier.sockets.command.GatewayReceiverCommand;
import org.apache.geode.internal.cache.tier.sockets.command.Get70;
import org.apache.geode.internal.cache.tier.sockets.command.GetAll70;
import org.apache.geode.internal.cache.tier.sockets.command.GetAllWithCallback;
import org.apache.geode.internal.cache.tier.sockets.command.GetClientPRMetadataCommand66;
import org.apache.geode.internal.cache.tier.sockets.command.GetClientPartitionAttributesCommand66;
import org.apache.geode.internal.cache.tier.sockets.command.GetEntry70;
import org.apache.geode.internal.cache.tier.sockets.command.GetFunctionAttribute;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXEnumById;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXIdForEnum;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXIdForType;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXTypeById;
import org.apache.geode.internal.cache.tier.sockets.command.GetPdxEnums70;
import org.apache.geode.internal.cache.tier.sockets.command.GetPdxTypes70;
import org.apache.geode.internal.cache.tier.sockets.command.Invalid;
import org.apache.geode.internal.cache.tier.sockets.command.Invalidate70;
import org.apache.geode.internal.cache.tier.sockets.command.KeySet;
import org.apache.geode.internal.cache.tier.sockets.command.MakePrimary;
import org.apache.geode.internal.cache.tier.sockets.command.PeriodicAck;
import org.apache.geode.internal.cache.tier.sockets.command.Ping;
import org.apache.geode.internal.cache.tier.sockets.command.Put70;
import org.apache.geode.internal.cache.tier.sockets.command.PutAll80;
import org.apache.geode.internal.cache.tier.sockets.command.PutAllWithCallback;
import org.apache.geode.internal.cache.tier.sockets.command.PutUserCredentials;
import org.apache.geode.internal.cache.tier.sockets.command.Query;
import org.apache.geode.internal.cache.tier.sockets.command.Query651;
import org.apache.geode.internal.cache.tier.sockets.command.QueryGeode10;
import org.apache.geode.internal.cache.tier.sockets.command.QueryWithParametersGeode10;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterDataSerializers;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInstantiators;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInterest61;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInterestList66;
import org.apache.geode.internal.cache.tier.sockets.command.RemoveAll;
import org.apache.geode.internal.cache.tier.sockets.command.RemoveUserAuth;
import org.apache.geode.internal.cache.tier.sockets.command.RequestEventValue;
import org.apache.geode.internal.cache.tier.sockets.command.RollbackCommand;
import org.apache.geode.internal.cache.tier.sockets.command.Size;
import org.apache.geode.internal.cache.tier.sockets.command.TXFailoverCommand;
import org.apache.geode.internal.cache.tier.sockets.command.TXSynchronizationCommand;
import org.apache.geode.internal.cache.tier.sockets.command.UnregisterInterest;
import org.apache.geode.internal.cache.tier.sockets.command.UnregisterInterestList;
import org.apache.geode.internal.cache.tier.sockets.command.UpdateClientNotification;
import org.apache.geode.internal.serialization.KnownVersion;

public class CommandInitializer
implements CommandRegistry {
    @Deprecated
    @MakeNotStatic
    static final CommandInitializer instance = new CommandInitializer();
    final Map<KnownVersion, Map<Integer, Command>> unmodifiableRegisteredCommands;
    final LinkedHashMap<KnownVersion, ConcurrentMap<Integer, Command>> modifiableRegisteredCommands = CommandInitializer.initializeAllCommands();

    @Deprecated
    public static CommandInitializer getDefaultInstance() {
        return instance;
    }

    public CommandInitializer() {
        this.unmodifiableRegisteredCommands = CommandInitializer.makeUnmodifiable(this.modifiableRegisteredCommands);
    }

    @Override
    public void register(int messageType, Map<KnownVersion, Command> versionToNewCommand) {
        if (!this.registerCommand(messageType, versionToNewCommand, this.modifiableRegisteredCommands)) {
            throw new InternalGemFireError(String.format("Message %d was not registered.", messageType));
        }
    }

    @Override
    public Map<Integer, Command> get(KnownVersion version) {
        return this.unmodifiableRegisteredCommands.get(version);
    }

    boolean registerCommand(int messageType, Map<KnownVersion, Command> versionToNewCommand, LinkedHashMap<KnownVersion, ConcurrentMap<Integer, Command>> allCommands) {
        boolean modified = false;
        Command command = null;
        for (Map.Entry<KnownVersion, ConcurrentMap<Integer, Command>> entry : allCommands.entrySet()) {
            KnownVersion version = entry.getKey();
            Map commandMap = entry.getValue();
            Command newCommand = versionToNewCommand.get(version);
            if (newCommand != null) {
                command = newCommand;
            }
            if (command == null) continue;
            Command oldCommand = (Command)commandMap.get(messageType);
            if (oldCommand != null && oldCommand != command) {
                throw new InternalGemFireError("Command is already defined int the map for message Type " + MessageType.getString(messageType) + ". Old Value=" + commandMap.get(messageType) + ", newValue=" + command + ", version=" + version);
            }
            commandMap.put(messageType, command);
            modified = true;
        }
        return modified;
    }

    private static LinkedHashMap<KnownVersion, ConcurrentMap<Integer, Command>> initializeAllCommands() {
        LinkedHashMap<KnownVersion, ConcurrentMap<Integer, Command>> allCommands = new LinkedHashMap<KnownVersion, ConcurrentMap<Integer, Command>>();
        ConcurrentMap<Integer, Command> gfe81Commands = CommandInitializer.buildGfe81Commands();
        allCommands.put(KnownVersion.GFE_81, gfe81Commands);
        ConcurrentMap<Integer, Command> gfe90Commands = CommandInitializer.buildGfe90Commands((ConcurrentMap)allCommands.get(KnownVersion.GFE_81));
        allCommands.put(KnownVersion.GFE_90, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_1_0, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_1_1, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_2_0, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_3_0, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_4_0, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_5_0, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_6_0, gfe90Commands);
        allCommands.put(KnownVersion.GEODE_1_7_0, gfe90Commands);
        ConcurrentMap<Integer, Command> geode18Commands = CommandInitializer.buildGeode18Commands((ConcurrentMap)allCommands.get(KnownVersion.GEODE_1_7_0));
        allCommands.put(KnownVersion.GEODE_1_8_0, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_9_0, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_10_0, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_11_0, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_12_0, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_12_1, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_13_0, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_13_2, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_14_0, geode18Commands);
        allCommands.put(KnownVersion.GEODE_1_15_0, geode18Commands);
        return allCommands;
    }

    private static ConcurrentMap<Integer, Command> buildGeode18Commands(ConcurrentMap<Integer, Command> baseCommands) {
        ConcurrentHashMap<Integer, Command> commands = new ConcurrentHashMap<Integer, Command>(baseCommands);
        CommandInitializer.initializeGeode18Commands(commands);
        return commands;
    }

    private static ConcurrentMap<Integer, Command> buildGfe90Commands(ConcurrentMap<Integer, Command> baseCommands) {
        ConcurrentHashMap<Integer, Command> commands = new ConcurrentHashMap<Integer, Command>(baseCommands);
        CommandInitializer.initializeGfe90Commands(commands);
        return commands;
    }

    private static ConcurrentMap<Integer, Command> buildGfe81Commands() {
        ConcurrentHashMap<Integer, Command> commands = new ConcurrentHashMap<Integer, Command>();
        CommandInitializer.initializeGfe81Commands(commands);
        return commands;
    }

    static void initializeGeode18Commands(Map<Integer, Command> commands) {
        commands.put(59, ExecuteRegionFunctionGeode18.getCommand());
    }

    static void initializeGfe90Commands(Map<Integer, Command> commands) {
        commands.put(80, QueryWithParametersGeode10.getCommand());
        commands.put(34, QueryGeode10.getCommand());
    }

    static void initializeGfe81Commands(Map<Integer, Command> commands) {
        commands.put(5, Ping.getCommand());
        commands.put(34, Query.getCommand());
        commands.put(36, ClearRegion.getCommand());
        commands.put(11, DestroyRegion.getCommand());
        commands.put(22, UnregisterInterest.getCommand());
        commands.put(25, UnregisterInterestList.getCommand());
        commands.put(40, KeySet.getCommand());
        commands.put(29, CreateRegion.getCommand());
        commands.put(31, MakePrimary.getCommand());
        commands.put(52, PeriodicAck.getCommand());
        commands.put(51, RegisterInstantiators.getCommand());
        commands.put(14, UpdateClientNotification.getCommand());
        commands.put(18, CloseConnection.getCommand());
        commands.put(53, ClientReady.getCommand());
        commands.put(-1, Invalid.getCommand());
        commands.put(20, RegisterInterest61.getCommand());
        commands.put(68, RequestEventValue.getCommand());
        commands.put(67, RegisterDataSerializers.getCommand());
        commands.put(77, PutUserCredentials.getCommand());
        commands.put(78, RemoveUserAuth.getCommand());
        commands.put(79, ExecuteRegionFunctionSingleHop.getCommand());
        commands.put(80, Query651.getCommand());
        commands.put(71, GetClientPRMetadataCommand66.getCommand());
        commands.put(94, AddPdxType.getCommand());
        commands.put(93, GetPDXIdForType.getCommand());
        commands.put(92, GetPDXTypeById.getCommand());
        commands.put(81, Size.getCommand());
        commands.put(85, CommitCommand.getCommand());
        commands.put(87, RollbackCommand.getCommand());
        commands.put(88, TXFailoverCommand.getCommand());
        commands.put(90, TXSynchronizationCommand.getCommand());
        commands.put(73, GetClientPartitionAttributesCommand66.getCommand());
        commands.put(24, RegisterInterestList66.getCommand());
        commands.put(91, GetFunctionAttribute.getCommand());
        commands.put(59, ExecuteRegionFunction66.getCommand());
        commands.put(104, GatewayReceiverCommand.getCommand());
        commands.put(38, ContainsKey66.getCommand());
        commands.put(96, AddPdxEnum.getCommand());
        commands.put(97, GetPDXIdForEnum.getCommand());
        commands.put(98, GetPDXEnumById.getCommand());
        commands.put(0, Get70.getCommand());
        commands.put(89, GetEntry70.getCommand());
        commands.put(100, GetAll70.getCommand());
        commands.put(7, Put70.getCommand());
        commands.put(9, Destroy70.getCommand());
        commands.put(83, Invalidate70.getCommand());
        commands.put(101, GetPdxTypes70.getCommand());
        commands.put(102, GetPdxEnums70.getCommand());
        commands.put(62, ExecuteFunction70.getCommand());
        commands.put(56, PutAll80.getCommand());
        commands.put(107, GetAllWithCallback.getCommand());
        commands.put(108, PutAllWithCallback.getCommand());
        commands.put(109, RemoveAll.getCommand());
    }

    static Map<KnownVersion, Map<Integer, Command>> makeUnmodifiable(Map<KnownVersion, ConcurrentMap<Integer, Command>> modifiableMap) {
        LinkedHashMap unmodifiableMap = new LinkedHashMap(modifiableMap.size());
        for (Map.Entry<KnownVersion, ConcurrentMap<Integer, Command>> e : modifiableMap.entrySet()) {
            unmodifiableMap.put(e.getKey(), Collections.unmodifiableMap((Map)e.getValue()));
        }
        return Collections.unmodifiableMap(unmodifiableMap);
    }
}

