/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.jetbrains.annotations.NotNull;

public class MakePrimary
extends BaseCommand {
    @Immutable
    private static final MakePrimary singleton = new MakePrimary();

    public static Command getCommand() {
        return singleton;
    }

    private MakePrimary() {
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, ClassNotFoundException {
        serverConnection.setAsTrue(2);
        Part isClientReadyPart = clientMessage.getPart(0);
        byte[] isClientReadyPartBytes = (byte[])isClientReadyPart.getObject();
        boolean isClientReady = isClientReadyPartBytes[0] == 1;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received make primary request ({} bytes) isClientReady={}: from {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)isClientReady, (Object)serverConnection.getSocketString());
        }
        try {
            serverConnection.getAcceptor().getCacheClientNotifier().makePrimary(serverConnection.getProxyID(), isClientReady);
            this.writeReply(clientMessage, serverConnection);
            serverConnection.setAsTrue(1);
            if (isDebugEnabled) {
                logger.debug("{}: Sent make primary response for {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString());
            }
        }
        catch (Exception e) {
            MakePrimary.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
        }
    }
}

