/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DistributedPingMessage;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.jetbrains.annotations.NotNull;

public class Ping
extends BaseCommand {
    @Immutable
    private static final Ping singleton = new Ping();

    public static Command getCommand() {
        return singleton;
    }

    private Ping() {
    }

    protected ClientHealthMonitor getClientHealthMonitor() {
        return ClientHealthMonitor.getInstance();
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException {
        ClientHealthMonitor chm;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: rcv tx: {} from {} rcvTime: {}", (Object)serverConnection.getName(), (Object)clientMessage.getTransactionId(), (Object)serverConnection.getSocketString(), (Object)(DistributionStats.getStatTime() - start));
        }
        if (clientMessage.getNumberOfParts() > 0) {
            try {
                InternalDistributedMember targetServer = (InternalDistributedMember)clientMessage.getPart(0).getObject();
                InternalDistributedMember myID = serverConnection.getCache().getMyId();
                if (!myID.equals(targetServer)) {
                    if (myID.compareTo(targetServer, true, false) == 0) {
                        String errorMessage = "Target server " + targetServer + " has different viewId: " + myID;
                        logger.warn(errorMessage);
                        Ping.writeException(clientMessage, new ServerOperationException(errorMessage), false, serverConnection);
                        serverConnection.setAsTrue(1);
                        return;
                    }
                    this.pingCorrectServer(clientMessage, targetServer, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Unable to deserialize message from " + serverConnection.getProxyID());
                Ping.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if ((chm = this.getClientHealthMonitor()) != null) {
            chm.receivedPing(serverConnection.getProxyID());
        }
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (isDebugEnabled) {
            logger.debug("{}: Sent ping reply to {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString());
        }
    }

    protected void pingCorrectServer(Message clientMessage, DistributedMember targetServer, ServerConnection serverConnection) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Received a Ping request from {} intended for {}. Forwarding the ping...", (Object)serverConnection.getProxyID(), (Object)targetServer);
        }
        if (!serverConnection.getCache().getDistributionManager().isCurrentMember(targetServer)) {
            String errorMessage = "Unable to ping non-member " + targetServer + " for client " + serverConnection.getProxyID();
            logger.warn(errorMessage);
            Ping.writeException(clientMessage, new ServerOperationException(errorMessage), false, serverConnection);
            serverConnection.setAsTrue(1);
        } else {
            DistributedPingMessage distributedPingMessage = new DistributedPingMessage(targetServer, serverConnection.getProxyID());
            serverConnection.getCache().getDistributionManager().putOutgoing(distributedPingMessage);
            this.writeReply(clientMessage, serverConnection);
        }
    }

    @Override
    protected void writeReply(@NotNull Message origMsg, @NotNull ServerConnection serverConnection) throws IOException {
        Message replyMsg = serverConnection.getReplyMessage();
        serverConnection.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(Ping.okBytes());
        replyMsg.send(serverConnection);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)serverConnection.getName(), (Object)origMsg.getTransactionId());
        }
    }
}

