/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.operations.UnregisterInterestOperationContext;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class UnregisterInterest
extends BaseCommand {
    @Immutable
    private static final UnregisterInterest singleton = new UnregisterInterest();

    public static Command getCommand() {
        return singleton;
    }

    UnregisterInterest() {
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws ClassNotFoundException, IOException {
        boolean keepAlive;
        Object key;
        serverConnection.setAsTrue(2);
        Part regionNamePart = clientMessage.getPart(0);
        InterestType interestType2 = InterestType.valueOf(clientMessage.getPart(1).getInt());
        Part keyPart = clientMessage.getPart(2);
        Part isClosingPart = clientMessage.getPart(3);
        byte[] isClosingPartBytes = (byte[])isClosingPart.getObject();
        boolean isClosing = isClosingPartBytes[0] == 1;
        String regionName = regionNamePart.getCachedString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            UnregisterInterest.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            Part keepAlivePart = clientMessage.getPart(4);
            byte[] keepAliveBytes = (byte[])keepAlivePart.getObject();
            keepAlive = keepAliveBytes[0] != 0;
        }
        catch (Exception e) {
            UnregisterInterest.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received unregister interest request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
        }
        String errMessage = null;
        if (key == null && regionName == null) {
            errMessage = "The input region name and key for the unregister interest request are null.";
        } else if (key == null) {
            errMessage = "The input key for the unregister interest request is null.";
        } else if (regionName == null) {
            errMessage = "The input region name for the unregister interest request is null.";
        }
        if (errMessage != null) {
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)errMessage);
            UnregisterInterest.writeErrorResponse(clientMessage, 23, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            if (interestType2 == InterestType.REGULAR_EXPRESSION) {
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
            } else {
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key);
            }
        }
        catch (NotAuthorizedException ex) {
            UnregisterInterest.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authorizeRequest = serverConnection.getAuthzRequest();
        if (authorizeRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
            try {
                UnregisterInterestOperationContext unregisterContext = authorizeRequest.unregisterInterestAuthorize(regionName, key, interestType2);
                key = unregisterContext.getKey();
            }
            catch (NotAuthorizedException ex) {
                UnregisterInterest.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        serverConnection.getAcceptor().getCacheClientNotifier().unregisterClientInterest(regionName, key, interestType2, isClosing, serverConnection.getProxyID(), keepAlive);
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent unregister interest response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
    }
}

