/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.xmlcache.PropertyResolver;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CacheXmlPropertyResolverHelper {
    private static final Logger logger = LogService.getLogger();
    public static final String DEFAULT_PROPERTY_STRING_PREFIX = "${";
    public static final String DEFAULT_PROPERTY_STRING_SUFFIX = "}";
    public static final String DEFAULT_PREFIX_FOR_SUFFIX = "{";
    @Immutable
    private static final Map<String, String> validSuffixAndPrefixes;
    private String propertyPrefix = "${";
    private String propertySuffix = "}";
    private String prefixForSuffix = "{";

    public CacheXmlPropertyResolverHelper(String propPrefix, String propSuffix) {
        if (propPrefix != null && propSuffix != null) {
            String validPrefix = validSuffixAndPrefixes.get(propSuffix);
            this.prefixForSuffix = validPrefix != null && propPrefix.endsWith(validPrefix) ? validPrefix : propPrefix;
            this.propertyPrefix = propPrefix;
            this.propertySuffix = propSuffix;
        }
    }

    protected String parseResolvablePropString(String unparsedString, PropertyResolver resolver, Set<String> visitedReplaceableStrings) {
        StringBuilder buf = new StringBuilder(unparsedString);
        int prefixIndex = buf.indexOf(this.propertyPrefix);
        while (prefixIndex != -1) {
            int suffixIndex = this.findSuffixIndex(buf, prefixIndex + this.propertyPrefix.length());
            if (suffixIndex != -1) {
                String replaceableString = buf.substring(prefixIndex + this.propertyPrefix.length(), suffixIndex);
                if (!visitedReplaceableStrings.add(replaceableString)) {
                    logger.info("Some still unresolved string {} was replaced by resolver, leading to circular references.", (Object)replaceableString);
                    throw new IllegalArgumentException("Some still unresolved string " + replaceableString + " was replaced by resolver, leading to circular references.");
                }
                String replacement = resolver.resolveReplaceString(replaceableString = this.parseResolvablePropString(replaceableString, resolver, visitedReplaceableStrings));
                if (replacement != null) {
                    replacement = this.parseResolvablePropString(replacement, resolver, visitedReplaceableStrings);
                    buf.replace(prefixIndex, suffixIndex + this.propertySuffix.length(), replacement);
                    prefixIndex = buf.indexOf(this.propertyPrefix, prefixIndex + replacement.length());
                } else if (resolver.isIgnoreUnresolvedProperties()) {
                    prefixIndex = buf.indexOf(this.propertyPrefix, suffixIndex + this.propertySuffix.length());
                } else {
                    throw new IllegalArgumentException("No replacement found for property : " + replaceableString);
                }
                visitedReplaceableStrings.remove(replaceableString);
                continue;
            }
            prefixIndex = -1;
        }
        return buf.toString();
    }

    private int findSuffixIndex(StringBuilder buf, int index) {
        int inNestedProperty = 0;
        while (index < buf.length()) {
            if (buf.substring(index, index + this.propertySuffix.length()).equalsIgnoreCase(this.propertySuffix)) {
                if (inNestedProperty > 0) {
                    --inNestedProperty;
                    index += this.propertySuffix.length();
                    continue;
                }
                return index;
            }
            if (buf.substring(index, index + this.prefixForSuffix.length()).equalsIgnoreCase(this.prefixForSuffix)) {
                ++inNestedProperty;
                index += this.prefixForSuffix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DEFAULT_PROPERTY_STRING_SUFFIX, DEFAULT_PREFIX_FOR_SUFFIX);
        map.put("]", "[");
        map.put(")", "(");
        validSuffixAndPrefixes = Collections.unmodifiableMap(map);
    }
}

