/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.datasource.AbstractDataSource;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class GemFireBasicDataSource
extends AbstractDataSource {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -4010116024816908360L;
    protected volatile transient Driver driverObject = this.loadDriver();

    public boolean isWrapperFor(Class iface) throws SQLException {
        return true;
    }

    public Object unwrap(Class iface) throws SQLException {
        return iface;
    }

    public GemFireBasicDataSource(ConfiguredDataSourceProperties configs) throws SQLException {
        super(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        Properties props;
        Connection connection = null;
        Driver localDriverRef = this.driverObject;
        if (localDriverRef == null) {
            GemFireBasicDataSource gemFireBasicDataSource = this;
            synchronized (gemFireBasicDataSource) {
                localDriverRef = this.driverObject;
                if (localDriverRef == null) {
                    this.driverObject = localDriverRef = this.loadDriver();
                }
            }
        }
        if (this.url != null) {
            props = new Properties();
            if (this.user != null) {
                props.put("user", this.user);
            }
            if (this.password != null) {
                props.put("password", this.password);
            }
        } else {
            String exception = "GemFireBasicDataSource::getConnection:Url for the DataSource not available";
            logger.info(exception);
            throw new SQLException(exception);
        }
        connection = this.driverObject.connect(this.url, props);
        return connection;
    }

    @Override
    public Connection getConnection(String clUsername, String clPassword) throws SQLException {
        this.checkCredentials(clUsername, clPassword);
        return this.getConnection();
    }

    private Driver loadDriver() throws SQLException {
        try {
            if (this.jdbcDriver != null && this.jdbcDriver.length() > 0) {
                return this.loadDriverUsingClassName();
            }
            return this.loadDriverUsingURL();
        }
        catch (Exception ex) {
            String msg = "An Exception was caught while trying to load the driver. %s";
            String msgArg = ex.getLocalizedMessage();
            logger.error(String.format(msg, msgArg), (Throwable)ex);
            throw new SQLException(String.format(msg, msgArg));
        }
    }

    private Driver loadDriverUsingURL() throws SQLException {
        return DriverManager.getDriver(this.url);
    }

    private Driver loadDriverUsingClassName() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> driverClass = ClassPathLoader.getLatest().forName(this.jdbcDriver);
        return (Driver)driverClass.newInstance();
    }
}

