/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.IOException;
import java.net.Socket;
import java.security.ProviderException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.SystemFailure;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.jetbrains.annotations.NotNull;

public class SocketCloser {
    static final long ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS = Long.getLong("p2p.ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS", 120L);
    static final int ASYNC_CLOSE_POOL_MAX_THREADS = Integer.getInteger("p2p.ASYNC_CLOSE_POOL_MAX_THREADS", 4);
    static final long ASYNC_CLOSE_WAIT_MILLISECONDS = Long.getLong("p2p.ASYNC_CLOSE_WAIT_MILLISECONDS", 0L);
    private final ConcurrentHashMap<String, ExecutorService> asyncCloseExecutors = new ConcurrentHashMap();
    private final int asyncClosePoolMaxThreads;
    private final long asyncCloseWaitTime;
    private final TimeUnit asyncCloseWaitUnits;
    private final ReentrantLock closedLock = new ReentrantLock();
    private boolean closed;

    public SocketCloser() {
        this(ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS, ASYNC_CLOSE_POOL_MAX_THREADS, ASYNC_CLOSE_WAIT_MILLISECONDS, TimeUnit.MILLISECONDS);
    }

    public SocketCloser(int asyncClosePoolMaxThreads, long asyncCloseWaitMillis) {
        this(ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS, asyncClosePoolMaxThreads, asyncCloseWaitMillis, TimeUnit.MILLISECONDS);
    }

    public SocketCloser(long asyncClosePoolKeepAliveSeconds, int asyncClosePoolMaxThreads, long asyncCloseWaitTime, TimeUnit asyncCloseWaitUnits) {
        this.asyncClosePoolMaxThreads = asyncClosePoolMaxThreads;
        this.asyncCloseWaitTime = asyncCloseWaitTime;
        this.asyncCloseWaitUnits = asyncCloseWaitUnits;
    }

    public int getMaxThreads() {
        return this.asyncClosePoolMaxThreads;
    }

    private ExecutorService getAsyncThreadExecutor(String address) {
        ExecutorService previousThreadPoolExecutor;
        ExecutorService executorService = this.asyncCloseExecutors.get(address);
        if (executorService == null && (previousThreadPoolExecutor = this.asyncCloseExecutors.putIfAbsent(address, executorService = this.getWorkStealingPool(this.asyncClosePoolMaxThreads))) != null) {
            executorService.shutdownNow();
            return previousThreadPoolExecutor;
        }
        return executorService;
    }

    private ExecutorService getWorkStealingPool(int maxParallelThreads) {
        return LoggingExecutors.newWorkStealingPool((String)"SocketCloser-", (int)maxParallelThreads);
    }

    public void releaseResourcesForAddress(String address) {
        ExecutorService executorService = this.asyncCloseExecutors.remove(address);
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public void close() {
        block5: {
            this.closedLock.lock();
            try {
                if (!this.closed) {
                    this.closed = true;
                    break block5;
                }
                return;
            }
            finally {
                this.closedLock.unlock();
            }
        }
        for (ExecutorService executorService : this.asyncCloseExecutors.values()) {
            executorService.shutdown();
        }
        this.asyncCloseExecutors.clear();
    }

    private Future asyncExecute(String address, Runnable runnableToExecute) {
        ExecutorService asyncThreadExecutor = this.getAsyncThreadExecutor(address);
        return asyncThreadExecutor.submit(runnableToExecute);
    }

    public void asyncClose(Socket socket, String address, Runnable runBeforeClose) {
        this.asyncClose(socket, address, runBeforeClose, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncClose(@NotNull Socket socket, @NotNull String address, @NotNull Runnable runBeforeClose, @NotNull Runnable runAfterClose) {
        if (socket.isClosed()) {
            return;
        }
        boolean doItInline = false;
        try {
            Future<SocketCloser> submittedTask = CompletableFuture.completedFuture(this);
            this.closedLock.lock();
            try {
                if (this.closed) {
                    doItInline = true;
                } else {
                    submittedTask = this.asyncExecute(address, () -> {
                        Thread.currentThread().setName("AsyncSocketCloser for " + address);
                        try {
                            runBeforeClose.run();
                            SocketCloser.inlineClose(socket);
                            runAfterClose.run();
                        }
                        finally {
                            Thread.currentThread().setName("unused AsyncSocketCloser");
                        }
                    });
                }
            }
            finally {
                this.closedLock.unlock();
            }
            if (!doItInline) {
                this.waitForFutureTaskWithTimeout(submittedTask);
                return;
            }
        }
        catch (OutOfMemoryError | RejectedExecutionException throwable) {
            // empty catch block
        }
        runBeforeClose.run();
        SocketCloser.inlineClose(socket);
        runAfterClose.run();
    }

    private void waitForFutureTaskWithTimeout(Future submittedTask) {
        if (this.asyncCloseWaitTime != 0L) {
            try {
                submittedTask.get(this.asyncCloseWaitTime, this.asyncCloseWaitUnits);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
    }

    private static void inlineClose(Socket sock) {
        block7: {
            try {
                sock.shutdownInput();
                sock.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sock.close();
            }
            catch (IOException iOException) {
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (ProviderException err) {
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                if (e.getCause() instanceof IOException) break block7;
                throw e;
            }
        }
    }
}

