/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net.filewatch;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public final class PollingFileWatcher {
    public static final long PERIOD_SECONDS = 10L;
    private static final Logger logger = LogService.getLogger();
    private final Path path;
    private final Runnable onUpdate;
    private final Runnable onError;
    private final ScheduledExecutorService executor;
    private long lastModifiedTimeMillis;

    PollingFileWatcher(Path path, Runnable onUpdate, Runnable onError) {
        this.path = path;
        this.onUpdate = onUpdate;
        this.onError = onError;
        try {
            this.lastModifiedTimeMillis = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new InternalGemFireException("Unable to start watching " + path, e);
        }
        this.executor = LoggingExecutors.newSingleThreadScheduledExecutor((String)PollingFileWatcher.threadNameForPath(path));
        this.executor.scheduleAtFixedRate(this::poll, 10L, 10L, TimeUnit.SECONDS);
        logger.info("Started watching {}", (Object)path);
    }

    void stop() {
        this.executor.shutdown();
        logger.info("Stopped watching {}", (Object)this.path);
    }

    private void poll() {
        try {
            long timeStampMillis = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
            if (timeStampMillis != this.lastModifiedTimeMillis) {
                logger.debug("Detected update for {}", (Object)this.path);
                this.lastModifiedTimeMillis = timeStampMillis;
                this.onUpdate.run();
            } else {
                logger.debug("No change detected for {}", (Object)this.path);
            }
        }
        catch (Exception e) {
            logger.debug("Error watching {}", (Object)this.path, (Object)e);
            this.onError.run();
        }
    }

    private static String threadNameForPath(Path path) {
        return String.format("file-watcher-%s-", path.getName(path.getNameCount() - 1));
    }
}

