/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import org.apache.commons.lang3.Validate;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.process.AttachProcessUtils;
import org.apache.geode.internal.process.NativeProcessUtils;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtilsProvider;
import org.apache.geode.internal.process.UncheckedPidUnavailableException;

public class ProcessUtils {
    @Immutable
    private static final ProcessUtilsProvider internal = ProcessUtils.initializeInternalProcessUtils();

    private ProcessUtils() {
    }

    public static int identifyPid() throws PidUnavailableException {
        return ProcessUtils.identifyPid(ManagementFactory.getRuntimeMXBean().getName());
    }

    public static int identifyPidAsUnchecked() throws UncheckedPidUnavailableException {
        try {
            return ProcessUtils.identifyPid();
        }
        catch (PidUnavailableException e) {
            throw new UncheckedPidUnavailableException(e);
        }
    }

    public static int identifyPid(String name) throws PidUnavailableException {
        Validate.notEmpty((CharSequence)name, (String)("Invalid name '" + name + "' specified"), (Object[])new Object[0]);
        try {
            int index = name.indexOf(64);
            if (index < 0) {
                throw new PidUnavailableException("Unable to parse pid from " + name);
            }
            return Integer.parseInt(name.substring(0, index));
        }
        catch (NumberFormatException e) {
            throw new PidUnavailableException("Unable to parse pid from " + name, e);
        }
    }

    public static boolean isProcessAlive(int pid) {
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"), (Object[])new Object[0]);
        return internal.isProcessAlive(pid);
    }

    public static boolean isProcessAlive(Process process) {
        Validate.notNull((Object)process, (String)("Invalid process '" + process + "' specified"), (Object[])new Object[0]);
        return process.isAlive();
    }

    public static boolean killProcess(int pid) {
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"), (Object[])new Object[0]);
        return internal.killProcess(pid);
    }

    public static int readPid(Path pidFile) {
        return ProcessUtils.readPid(pidFile.toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readPid(File pidFile) {
        Validate.notNull((Object)pidFile, (String)("Invalid pidFile '" + pidFile + "' specified"), (Object[])new Object[0]);
        Validate.isTrue((boolean)pidFile.exists(), (String)("Nonexistent pidFile '" + pidFile + "' specified"), (Object[])new Object[0]);
        try (BufferedReader reader = new BufferedReader(new FileReader(pidFile));){
            int n = Integer.parseInt(reader.readLine());
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isAvailable() {
        return internal.isAvailable();
    }

    public static boolean isAttachApiAvailable() {
        return internal.isAttachApiAvailable();
    }

    private static ProcessUtilsProvider initializeInternalProcessUtils() {
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            Class.forName("com.sun.tools.attach.VirtualMachineDescriptor");
            return new AttachProcessUtils();
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            try {
                Class.forName("org.apache.geode.internal.shared.NativeCalls");
                NativeProcessUtils nativeProcessUtils = new NativeProcessUtils();
                boolean result = nativeProcessUtils.isProcessAlive(ProcessUtils.identifyPid());
                if (result) {
                    return nativeProcessUtils;
                }
            }
            catch (ClassNotFoundException | LinkageError | UnsupportedOperationException | PidUnavailableException throwable2) {
                // empty catch block
            }
            return new ProcessUtilsProvider(){

                @Override
                public boolean isProcessAlive(int pid) {
                    return false;
                }

                @Override
                public boolean killProcess(int pid) {
                    return false;
                }

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public boolean isAttachApiAvailable() {
                    return false;
                }
            };
        }
    }
}

