/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.shared;

import com.sun.jna.Callback;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.process.signal.Signal;
import org.apache.geode.internal.shared.NativeCalls;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class NativeCallsJNAImpl {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final NativeCalls instance = NativeCallsJNAImpl.getImplInstance();

    private NativeCallsJNAImpl() {
    }

    private static NativeCalls getImplInstance() {
        if (Platform.isLinux()) {
            return new LinuxNativeCalls();
        }
        if (Platform.isWindows()) {
            return new WinNativeCalls();
        }
        return new POSIXNativeCalls();
    }

    public static NativeCalls getInstance() {
        return instance;
    }

    private static class WinNativeCalls
    extends NativeCalls {
        private WinNativeCalls() {
        }

        @Override
        public synchronized String getEnvironment(String name) {
            if (name == null) {
                throw new UnsupportedOperationException("getEnvironment() for name=NULL");
            }
            int psize = Kernel32.INSTANCE.GetEnvironmentVariable(name, null, 0);
            if (psize > 0) {
                do {
                    char[] result;
                    if ((psize = Kernel32.INSTANCE.GetEnvironmentVariable(name, result = new char[psize], psize)) != result.length - 1) continue;
                    return new String(result, 0, psize);
                } while (psize > 0);
                return null;
            }
            return null;
        }

        @Override
        public int getProcessId() {
            return Kernel32.INSTANCE.GetCurrentProcessId();
        }

        @Override
        public boolean isProcessActive(int processId) {
            try {
                WinNT.HANDLE procHandle = Kernel32.INSTANCE.OpenProcess(1024, false, processId);
                if (procHandle == null || WinBase.INVALID_HANDLE_VALUE.equals((Object)procHandle)) {
                    return false;
                }
                IntByReference status = new IntByReference();
                boolean result = Kernel32.INSTANCE.GetExitCodeProcess(procHandle, status) && status.getValue() == 259;
                Kernel32.INSTANCE.CloseHandle(procHandle);
                return result;
            }
            catch (LastErrorException le) {
                return false;
            }
        }

        @Override
        public boolean killProcess(int processId) {
            try {
                WinNT.HANDLE procHandle = Kernel32.INSTANCE.OpenProcess(1, false, processId);
                if (procHandle == null || Kernel32.INVALID_HANDLE_VALUE.equals((Object)procHandle)) {
                    return false;
                }
                boolean result = Kernel32.INSTANCE.TerminateProcess(procHandle, -1);
                Kernel32.INSTANCE.CloseHandle(procHandle);
                return result;
            }
            catch (LastErrorException le) {
                return false;
            }
        }

        @Override
        public void daemonize(NativeCalls.RehashServerOnSIGHUP callback) throws UnsupportedOperationException, IllegalStateException {
            throw new IllegalStateException("daemonize() not applicable for Windows platform");
        }
    }

    private static class LinuxNativeCalls
    extends POSIXNativeCalls {
        @MakeNotStatic
        private static boolean isStatFSEnabled;
        @Immutable
        private static final String[] FallocateFileSystems;

        private LinuxNativeCalls() {
        }

        public static native int posix_fallocate64(int var0, long var1, long var3);

        public static native int creat64(String var0, int var1) throws LastErrorException;

        public String getFileStoreType(String path) {
            Path currentPath;
            File diskFile = new File(path);
            if (!diskFile.exists()) {
                diskFile = diskFile.getParentFile();
            }
            if ((currentPath = diskFile.toPath()).isAbsolute() && Files.exists(currentPath, new LinkOption[0])) {
                try {
                    FileStore store = Files.getFileStore(currentPath);
                    return store.type();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isOnLocalFileSystem(String path) {
            if (!isStatFSEnabled) {
                return false;
            }
            int numTries = 10;
            for (int i = 1; i <= 10; ++i) {
                try {
                    if (Platform.is64Bit()) {
                        StatFS64 stat = new StatFS64();
                        StatFS64.statfs(path, stat);
                        return stat.isTypeLocal();
                    }
                    StatFS stat = new StatFS();
                    StatFS.statfs(path, stat);
                    return stat.isTypeLocal();
                }
                catch (LastErrorException le) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("DEBUG isOnLocalFileSystem got ex = " + (Object)((Object)le) + " msg = " + le.getMessage());
                    continue;
                }
            }
            return false;
        }

        @Override
        protected boolean hasFallocate(String path) {
            String fstype = this.getFileStoreType(path);
            for (String type : FallocateFileSystems) {
                if (!type.equalsIgnoreCase(fstype)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int createFD(String path, int flags) throws LastErrorException {
            return LinuxNativeCalls.creat64(path, flags);
        }

        @Override
        protected void fallocateFD(int fd, long offset, long len) throws LastErrorException {
            int errno = LinuxNativeCalls.posix_fallocate64(fd, offset, len);
            if (errno != 0) {
                throw new LastErrorException(errno);
            }
        }

        static {
            Native.register((String)"c");
            if (Platform.is64Bit()) {
                StatFS64.dummy();
            } else {
                StatFS.dummy();
            }
            FallocateFileSystems = new String[]{"ext4", "xfs", "btrfs", "ocfs2"};
        }

        public static class StatFS64
        extends Structure {
            public long f_type;
            public long f_bsize;
            public long f_blocks;
            public long f_bfree;
            public long f_bavail;
            public long f_files;
            public long f_ffree;
            public FSIDIntArr2 f_fsid;
            public long f_namelen;
            public long f_frsize;
            public FSPARELongArr5 f_spare;
            @Immutable
            private static final long[] REMOTE_TYPES = new long[]{4283649346L, 1937076805L, 22092L, 26985L, 20859L, 16914836L};

            public static native int statfs(String var0, StatFS64 var1) throws LastErrorException;

            protected List<String> getFieldOrder() {
                return Arrays.asList("f_type", "f_bsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_fsid", "f_namelen", "f_frsize", "f_spare");
            }

            public boolean isTypeLocal() {
                for (long remoteType : REMOTE_TYPES) {
                    if (remoteType != this.f_type) continue;
                    return false;
                }
                return true;
            }

            public static void dummy() {
            }

            static {
                try {
                    Native.register((String)"rt");
                    StatFS64 struct = new StatFS64();
                    int ret = StatFS64.statfs(".", struct);
                    isStatFSEnabled = ret == 0;
                }
                catch (Throwable t) {
                    System.out.println("got error t: " + t.getMessage());
                    t.printStackTrace();
                    isStatFSEnabled = false;
                }
            }
        }

        public static class FSPARELongArr5
        extends Structure {
            public long[] fspare = new long[5];

            protected List<String> getFieldOrder() {
                return Collections.singletonList("fspare");
            }
        }

        public static class StatFS
        extends Structure {
            public int f_type;
            public int f_bsize;
            public int f_blocks;
            public int f_bfree;
            public int f_bavail;
            public int f_files;
            public int f_ffree;
            public FSIDIntArr2 f_fsid;
            public int f_namelen;
            public int f_frsize;
            public FSPAREIntArr5 f_spare;
            @Immutable
            private static final int[] REMOTE_TYPES;

            public static native int statfs(String var0, StatFS var1) throws LastErrorException;

            protected List<String> getFieldOrder() {
                return Arrays.asList("f_type", "f_bsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_fsid", "f_namelen", "f_frsize", "f_spare");
            }

            public boolean isTypeLocal() {
                for (int remoteType : REMOTE_TYPES) {
                    if (remoteType != this.f_type) continue;
                    return false;
                }
                return true;
            }

            public static void dummy() {
            }

            static {
                try {
                    Native.register((String)"rt");
                    StatFS struct = new StatFS();
                    int ret = StatFS.statfs(".", struct);
                    isStatFSEnabled = ret == 0;
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    isStatFSEnabled = false;
                }
                REMOTE_TYPES = new int[]{1937076805, 22092, 26985, 20859, 16914836};
            }
        }

        public static class FSPAREIntArr5
        extends Structure {
            public int[] fspare = new int[5];

            protected List<String> getFieldOrder() {
                return Collections.singletonList("fspare");
            }
        }

        public static class FSIDIntArr2
        extends Structure {
            public int[] fsid = new int[2];

            protected List<String> getFieldOrder() {
                return Collections.singletonList("fsid");
            }
        }
    }

    private static class POSIXNativeCalls
    extends NativeCalls {
        static final int EPERM = 1;
        static final int ENOSPC = 28;
        SignalHandler hupHandler;
        NativeCalls.RehashServerOnSIGHUP rehashCallback;

        private POSIXNativeCalls() {
        }

        public static native String getenv(String var0);

        public static native int getpid();

        public static native int kill(int var0, int var1) throws LastErrorException;

        public static native int setsid() throws LastErrorException;

        public static native int umask(int var0);

        public static native int signal(int var0, SignalHandler var1);

        public static native int close(int var0) throws LastErrorException;

        @Override
        public synchronized String getEnvironment(String name) {
            if (name == null) {
                throw new UnsupportedOperationException("getEnvironment() for name=NULL");
            }
            return POSIXNativeCalls.getenv(name);
        }

        @Override
        public int getProcessId() {
            return POSIXNativeCalls.getpid();
        }

        @Override
        public boolean isProcessActive(int processId) {
            try {
                return POSIXNativeCalls.kill(processId, 0) == 0;
            }
            catch (LastErrorException le) {
                return le.getErrorCode() == 1;
            }
        }

        @Override
        public boolean killProcess(int processId) {
            try {
                return POSIXNativeCalls.kill(processId, 9) == 0;
            }
            catch (LastErrorException le) {
                return false;
            }
        }

        @Override
        public void daemonize(NativeCalls.RehashServerOnSIGHUP callback) throws UnsupportedOperationException {
            UnsupportedOperationException err;
            block4: {
                err = null;
                try {
                    POSIXNativeCalls.setsid();
                }
                catch (LastErrorException le) {
                    if (le.getErrorCode() == 1) break block4;
                    err = new UnsupportedOperationException("Failed in setsid() in daemonize() due to " + le.getMessage() + " (errno=" + le.getErrorCode() + ')');
                }
            }
            int newMask = 18;
            int oldMask = POSIXNativeCalls.umask(18);
            int OCTAL_077 = 63;
            if ((oldMask & 0x3F) > 18) {
                POSIXNativeCalls.umask(oldMask);
            }
            this.rehashCallback = callback;
            this.hupHandler = signum -> {
                NativeCalls.RehashServerOnSIGHUP rehashCb = this.rehashCallback;
                if (signum == Signal.SIGHUP.getNumber() && rehashCb != null) {
                    rehashCb.rehash();
                }
            };
            POSIXNativeCalls.signal(Signal.SIGHUP.getNumber(), this.hupHandler);
            POSIXNativeCalls.signal(Signal.SIGCHLD.getNumber(), this.hupHandler);
            POSIXNativeCalls.signal(Signal.SIGINT.getNumber(), this.hupHandler);
            if (err != null) {
                throw err;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preBlow(String path, long maxSize, boolean preAllocate) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("DEBUG preBlow called for path = " + path);
            }
            if (!preAllocate || !this.hasFallocate(path)) {
                super.preBlow(path, maxSize, preAllocate);
                if (logger.isDebugEnabled()) {
                    logger.debug("DEBUG preBlow super.preBlow 1 called for path = " + path);
                }
                return;
            }
            int fd = -1;
            boolean unknownError = false;
            try {
                int OCTAL_0644 = 420;
                fd = this.createFD(path, 420);
                if (!this.isOnLocalFileSystem(path)) {
                    super.preBlow(path, maxSize, preAllocate);
                    if (logger.isDebugEnabled()) {
                        logger.debug("DEBUG preBlow super.preBlow 2 called as path = " + path + " not on local file system");
                    }
                    if (DiskStoreImpl.TEST_NO_FALLOC_DIRS != null) {
                        DiskStoreImpl.TEST_NO_FALLOC_DIRS.add(path);
                    }
                    return;
                }
                this.fallocateFD(fd, 0L, maxSize);
                if (DiskStoreImpl.TEST_CHK_FALLOC_DIRS != null) {
                    DiskStoreImpl.TEST_CHK_FALLOC_DIRS.add(path);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("DEBUG preBlow posix_fallocate called for path = " + path + " and ret = 0 maxsize = " + maxSize);
                }
            }
            catch (LastErrorException le) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DEBUG preBlow posix_fallocate called for path = " + path + " and ret = " + le.getErrorCode() + " maxsize = " + maxSize);
                }
                if (le.getErrorCode() == 28) {
                    throw new IOException("Not enough space left on device");
                }
                unknownError = true;
            }
            finally {
                if (fd >= 0) {
                    try {
                        POSIXNativeCalls.close(fd);
                    }
                    catch (Exception exception) {}
                }
                if (unknownError) {
                    super.preBlow(path, maxSize, preAllocate);
                    if (logger.isDebugEnabled()) {
                        logger.debug("DEBUG preBlow super.preBlow 3 called for path = " + path);
                    }
                }
            }
        }

        protected boolean hasFallocate(String path) {
            return false;
        }

        protected int createFD(String path, int flags) throws LastErrorException {
            throw new UnsupportedOperationException("not expected to be invoked");
        }

        protected void fallocateFD(int fd, long offset, long len) throws LastErrorException {
            throw new UnsupportedOperationException("not expected to be invoked");
        }

        static {
            Native.register((String)"c");
        }

        static interface SignalHandler
        extends Callback {
            public void callback(int var1);
        }
    }
}

