/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import java.util.Map;
import org.apache.geode.internal.size.SingleObjectSizer;
import org.apache.geode.internal.util.concurrent.CopyOnWriteWeakHashMap;

public class CachingSingleObjectSizer
implements SingleObjectSizer {
    private final Map<Class, Long> sizeCache = new CopyOnWriteWeakHashMap<Class, Long>();
    private final SingleObjectSizer wrappedSizer;

    public CachingSingleObjectSizer(SingleObjectSizer sizer) {
        this.wrappedSizer = sizer;
    }

    @Override
    public long sizeof(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return this.wrappedSizer.sizeof(object);
        }
        Long size = this.sizeCache.get(clazz);
        if (size != null) {
            return size;
        }
        size = this.wrappedSizer.sizeof(object);
        this.sizeCache.put(clazz, size);
        return size;
    }
}

