/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

public class StatArchiveDescriptor {
    private final String archiveName;
    private final long systemId;
    private final long systemStartTime;
    private final String systemDirectoryPath;
    private final String productDescription;

    public String getArchiveName() {
        return this.archiveName;
    }

    public long getSystemId() {
        return this.systemId;
    }

    public long getSystemStartTime() {
        return this.systemStartTime;
    }

    public String getSystemDirectoryPath() {
        return this.systemDirectoryPath;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{archiveName=" + this.archiveName + ", systemId=" + this.systemId + ", systemStartTime=" + this.systemStartTime + ", systemDirectoryPath=" + this.systemDirectoryPath + ", productDescription=" + this.productDescription + "}";
    }

    private StatArchiveDescriptor(Builder builder) {
        this.archiveName = builder.archiveName;
        this.systemId = builder.systemId;
        this.systemStartTime = builder.systemStartTime;
        this.systemDirectoryPath = builder.systemDirectoryPath;
        this.productDescription = builder.productDescription;
    }

    public static class Builder {
        private String archiveName;
        private long systemId = -1L;
        private long systemStartTime = -1L;
        private String systemDirectoryPath;
        private String productDescription;

        public Builder setArchiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public Builder setSystemId(long systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder setSystemStartTime(long systemStartTime) {
            this.systemStartTime = systemStartTime;
            return this;
        }

        public Builder setSystemDirectoryPath(String systemDirectoryPath) {
            this.systemDirectoryPath = systemDirectoryPath;
            return this;
        }

        public Builder setProductDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public StatArchiveDescriptor build() throws IllegalStateException {
            if (this.archiveName == null) {
                throw new IllegalStateException("archiveName must not be null");
            }
            if (this.systemId == -1L) {
                throw new IllegalStateException("systemId must be a postive number");
            }
            if (this.systemStartTime == -1L) {
                throw new IllegalStateException("systemStartTime must be a postive number");
            }
            if (this.systemDirectoryPath == null) {
                throw new IllegalStateException("systemDirectoryPath must not be null");
            }
            if (this.productDescription == null) {
                throw new IllegalStateException("productDescription must not be null");
            }
            return new StatArchiveDescriptor(this);
        }
    }
}

