/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.ObjToByteArraySerializer;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.tcp.Connection;

public class MsgOutputStream
extends OutputStream
implements ObjToByteArraySerializer {
    private final ByteBuffer buffer;

    public MsgOutputStream(int allocSize) {
        this.buffer = BufferPool.useDirectBuffers ? ByteBuffer.allocateDirect(allocSize) : ByteBuffer.allocate(allocSize);
        this.buffer.position(7);
    }

    @Override
    public void write(int b) {
        this.buffer.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] source, int offset, int len) {
        this.buffer.put(source, offset, len);
    }

    private int size() {
        return this.buffer.position() - 7;
    }

    public void setMessageHeader(int msgType, int processorType, short msgId) {
        this.buffer.putInt(0, Connection.calcHdrSize(this.size()));
        this.buffer.put(4, (byte)(msgType & 0xFF));
        this.buffer.putShort(5, msgId);
    }

    public void reset() {
        this.buffer.clear();
        this.buffer.position(7);
    }

    public ByteBuffer getContentBuffer() {
        this.buffer.flip();
        return this.buffer;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.buffer.putShort((short)(v & 0xFFFF));
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.buffer.putLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 0) {
            if (this.buffer.hasArray()) {
                int pos = this.buffer.position();
                str.getBytes(0, strlen, this.buffer.array(), this.buffer.arrayOffset() + pos);
                this.buffer.position(pos + strlen);
            } else {
                byte[] bytes = new byte[strlen];
                str.getBytes(0, strlen, bytes, 0);
                this.buffer.put(bytes);
            }
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                this.buffer.putChar(s.charAt(i));
            }
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.writeFullUTF(str);
    }

    private void writeFullUTF(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 65535) {
            throw new UTFDataFormatException("String too long for java serialization");
        }
        int utfSizeIdx = this.buffer.position();
        this.buffer.position(utfSizeIdx + 2);
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                this.buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
            this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
        int utflen = this.buffer.position() - (utfSizeIdx + 2);
        if (utflen > 65535) {
            this.buffer.position(utfSizeIdx);
            throw new UTFDataFormatException("String too long for java serialization");
        }
        this.buffer.putShort(utfSizeIdx, (short)utflen);
    }

    @Override
    public void writeAsSerializedByteArray(Object v) throws IOException {
        ByteBuffer sizeBuf = this.buffer;
        int sizePos = sizeBuf.position();
        sizeBuf.position(sizePos + 5);
        int preArraySize = this.size();
        DataSerializer.writeObject(v, this);
        int arraySize = this.size() - preArraySize;
        sizeBuf.put(sizePos, (byte)-3);
        sizeBuf.putInt(sizePos + 1, arraySize);
    }
}

