/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MBeanProxyFactory;
import org.apache.geode.management.internal.ManagementCacheListener;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.Manager;
import org.apache.geode.management.internal.ManagerMembership;
import org.apache.geode.management.internal.MemberMessenger;
import org.apache.geode.management.internal.NotificationCacheListener;
import org.apache.geode.management.internal.NotificationKey;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class FederatingManager
extends Manager
implements ManagerMembership {
    private static final Logger logger = LogService.getLogger();
    private final AtomicReference<ExecutorService> executorService = new AtomicReference();
    private final AtomicReference<Exception> latestException = new AtomicReference();
    private final List<Runnable> pendingTasks = new CopyOnWriteArrayList<Runnable>();
    private final SystemManagementService service;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final MBeanProxyFactory proxyFactory;
    private final MemberMessenger messenger;
    private final ReentrantLock lifecycleLock;
    private volatile boolean starting;

    @VisibleForTesting
    FederatingManager(ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock, MBeanProxyFactory proxyFactory, MemberMessenger messenger, ExecutorService executorService) {
        this(repo, system, service, cache, statisticsFactory, statisticsClock, proxyFactory, messenger, () -> executorService);
    }

    FederatingManager(ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock, MBeanProxyFactory proxyFactory, MemberMessenger messenger, Supplier<ExecutorService> executorServiceSupplier) {
        super(repo, system, cache, statisticsFactory, statisticsClock);
        this.service = service;
        this.proxyFactory = proxyFactory;
        this.messenger = messenger;
        this.executorServiceSupplier = executorServiceSupplier;
        this.lifecycleLock = new ReentrantLock();
    }

    @Override
    public void startManager() {
        try {
            this.lifecycleLock.lock();
            try {
                if (this.starting || this.running) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting the Federating Manager.... ");
                }
                this.starting = true;
                this.executorService.set(this.executorServiceSupplier.get());
                this.running = true;
            }
            finally {
                this.lifecycleLock.unlock();
            }
            this.startManagingActivity();
            this.lifecycleLock.lock();
            try {
                for (Runnable task : this.pendingTasks) {
                    this.executeTask(task);
                }
            }
            finally {
                this.pendingTasks.clear();
                this.starting = false;
                this.lifecycleLock.unlock();
            }
            this.messenger.broadcastManagerInfo();
        }
        catch (Exception e) {
            this.cleanupFailedStart();
            throw new ManagementException(e);
        }
    }

    private void cleanupFailedStart() {
        this.lifecycleLock.lock();
        try {
            this.pendingTasks.clear();
            this.running = false;
            this.starting = false;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void stopManager() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Stopping the Federating Manager.... ");
            }
            this.running = false;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        this.stopManagingActivity();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void addMember(InternalDistributedMember member) {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                return;
            }
            this.executeTask(() -> new AddMemberTask(member).call());
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMember(DistributedMember member, boolean crashed) {
        this.lifecycleLock.lock();
        try {
            RemoveMemberTask task = new RemoveMemberTask(member, crashed);
            if (this.starting) {
                this.pendingTasks.add(task);
            } else if (this.running) {
                this.executeTask(task);
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void suspectMember(DistributedMember member, InternalDistributedMember whoSuspected, String reason) {
        this.service.memberSuspect((InternalDistributedMember)member, whoSuspected, reason);
    }

    public MemberMessenger getMessenger() {
        return this.messenger;
    }

    long getLastUpdateTime(ObjectName objectName) {
        return this.proxyFactory.getLastUpdateTime(objectName);
    }

    <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyFactory.findProxy(objectName, interfaceClass);
    }

    Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyFactory.findAllProxies(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startManagingActivity() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        ArrayList<AddMemberTask> giiTaskList = new ArrayList<AddMemberTask>();
        for (InternalDistributedMember member : this.system.getDistributionManager().getOtherDistributionManagerIds()) {
            giiTaskList.add(new AddMemberTask(member));
        }
        try {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation started  : ");
            }
            List futureTaskList = this.executorService.get().invokeAll(giiTaskList);
            for (Future futureTask : futureTaskList) {
                try {
                    String memberId;
                    DistributedMember returnedMember = (DistributedMember)futureTask.get();
                    String string = memberId = returnedMember != null ? returnedMember.getId() : null;
                    if (futureTask.isDone() && isDebugEnabled) {
                        logger.debug("Monitoring Resource Created for : {}", (Object)memberId);
                    }
                    if (!futureTask.isCancelled() || !isDebugEnabled) continue;
                    logger.debug("Monitoring resource Creation Failed for : {}", (Object)memberId);
                }
                catch (ExecutionException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("ExecutionException during Management GII", (Throwable)e);
                }
                catch (CancellationException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("InterruptedException while creating Monitoring resource with error", (Throwable)new ManagementException(e));
                }
            }
        }
        catch (InterruptedException e) {
            if (isDebugEnabled) {
                logger.debug("InterruptedException while creating Monitoring resource with error", (Throwable)new ManagementException(e));
            }
        }
        finally {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation completed");
            }
        }
    }

    private void stopManagingActivity() {
        try {
            this.executorService.get().shutdownNow();
            for (DistributedMember distributedMember : this.repo.getMonitoringRegionMap().keySet()) {
                this.removeMemberArtifacts(distributedMember, false);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    private void executeTask(Runnable task) {
        try {
            this.executorService.get().execute(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void addMemberArtifacts(InternalDistributedMember member) {
        InternalDistributedMember internalDistributedMember = member;
        synchronized (internalDistributedMember) {
            block24: {
                String appender = MBeanJMXAdapter.getUniqueIDForMember(member);
                String monitoringRegionName = "_monitoringRegion_" + appender;
                String notificationRegionName = "_notificationRegion_" + appender;
                if (this.cache.getInternalRegion(monitoringRegionName) != null && this.cache.getInternalRegion(notificationRegionName) != null) {
                    return;
                }
                try {
                    Region<NotificationKey, Notification> proxyNotificationRegion;
                    Region<String, Object> proxyMonitoringRegion;
                    if (Thread.currentThread().isInterrupted()) break block24;
                    HasCachePerfStats monitoringRegionStats = new HasCachePerfStats(){

                        @Override
                        public CachePerfStats getCachePerfStats() {
                            return new CachePerfStats(FederatingManager.this.cache.getDistributedSystem(), "RegionStats-managementRegionStats", FederatingManager.this.statisticsClock);
                        }

                        @Override
                        public boolean hasOwnStats() {
                            return true;
                        }
                    };
                    InternalRegionFactory<String, Object> monitorFactory = this.cache.createInternalRegionFactory();
                    monitorFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    monitorFactory.setDataPolicy(DataPolicy.REPLICATE);
                    monitorFactory.setConcurrencyChecksEnabled(false);
                    ManagementCacheListener managementCacheListener = new ManagementCacheListener(this.proxyFactory);
                    monitorFactory.addCacheListener(managementCacheListener);
                    monitorFactory.setIsUsedForMetaRegion(true);
                    monitorFactory.setCachePerfStatsHolder(monitoringRegionStats);
                    InternalRegionFactory<NotificationKey, Notification> notificationFactory = this.cache.createInternalRegionFactory();
                    notificationFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    notificationFactory.setDataPolicy(DataPolicy.REPLICATE);
                    notificationFactory.setConcurrencyChecksEnabled(false);
                    notificationFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes(10, EvictionAction.LOCAL_DESTROY));
                    NotificationCacheListener notifListener = new NotificationCacheListener(this.proxyFactory);
                    notificationFactory.addCacheListener(notifListener);
                    notificationFactory.setIsUsedForMetaRegion(true);
                    notificationFactory.setCachePerfStatsHolder(monitoringRegionStats);
                    try {
                        if (!this.running) {
                            return;
                        }
                        proxyMonitoringRegion = monitorFactory.create(monitoringRegionName);
                    }
                    catch (RegionExistsException | TimeoutException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error During Internal Region creation", (Throwable)e);
                        }
                        throw new ManagementException(e);
                    }
                    boolean proxyNotificationRegionCreated = false;
                    try {
                        if (!this.running) {
                            return;
                        }
                        proxyNotificationRegion = notificationFactory.create(notificationRegionName);
                        proxyNotificationRegionCreated = true;
                    }
                    catch (RegionExistsException | TimeoutException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error During Internal Region creation", (Throwable)e);
                        }
                        throw new ManagementException(e);
                    }
                    finally {
                        if (!proxyNotificationRegionCreated) {
                            proxyMonitoringRegion.localDestroyRegion();
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Management Region created with Name : {}", (Object)proxyMonitoringRegion.getName());
                        logger.debug("Notification Region created with Name : {}", (Object)proxyNotificationRegion.getName());
                    }
                    this.repo.putEntryInMonitoringRegionMap(member, proxyMonitoringRegion);
                    this.repo.putEntryInNotifRegionMap(member, proxyNotificationRegion);
                    try {
                        if (!this.running) {
                            return;
                        }
                        this.proxyFactory.createAllProxies(member, proxyMonitoringRegion);
                        managementCacheListener.markReady();
                        notifListener.markReady();
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error During GII Proxy creation", (Throwable)e);
                        }
                        throw new ManagementException(e);
                    }
                }
                catch (Exception e) {
                    throw new ManagementException(e);
                }
            }
            this.service.memberJoined(member);
            this.messenger.sendManagerInfo(member);
        }
    }

    @VisibleForTesting
    void removeMemberArtifacts(DistributedMember member, boolean crashed) {
        Region<String, Object> monitoringRegion = this.repo.getEntryFromMonitoringRegionMap(member);
        Region<NotificationKey, Notification> notificationRegion = this.repo.getEntryFromNotifRegionMap(member);
        if (monitoringRegion == null && notificationRegion == null) {
            return;
        }
        this.repo.romoveEntryFromMonitoringRegionMap(member);
        this.repo.removeEntryFromNotifRegionMap(member);
        if (!this.cache.isClosed()) {
            try {
                if (monitoringRegion != null) {
                    this.proxyFactory.removeAllProxies(member, monitoringRegion);
                    monitoringRegion.localDestroyRegion();
                }
            }
            catch (CancelException | RegionDestroyedException cacheRuntimeException) {
                // empty catch block
            }
            try {
                if (notificationRegion != null) {
                    notificationRegion.localDestroyRegion();
                }
            }
            catch (CancelException | RegionDestroyedException cacheRuntimeException) {
                // empty catch block
            }
        }
        if (!this.system.getDistributedMember().equals(member)) {
            try {
                this.service.memberDeparted((InternalDistributedMember)member, crashed);
            }
            catch (CancelException | RegionDestroyedException cacheRuntimeException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    public MBeanProxyFactory proxyFactory() {
        return this.proxyFactory;
    }

    @VisibleForTesting
    Exception latestException() {
        return this.latestException.getAndSet(null);
    }

    @VisibleForTesting
    List<Runnable> pendingTasks() {
        return this.pendingTasks;
    }

    @VisibleForTesting
    boolean isStarting() {
        return this.starting;
    }

    private class RemoveMemberTask
    implements Runnable {
        private final DistributedMember member;
        private final boolean crashed;

        private RemoveMemberTask(DistributedMember member, boolean crashed) {
            this.member = member;
            this.crashed = crashed;
        }

        @Override
        public void run() {
            FederatingManager.this.removeMemberArtifacts(this.member, this.crashed);
        }
    }

    private class AddMemberTask
    implements Callable<InternalDistributedMember> {
        private final InternalDistributedMember member;

        private AddMemberTask(InternalDistributedMember member) {
            this.member = member;
        }

        @Override
        public InternalDistributedMember call() {
            FederatingManager.this.addMemberArtifacts(this.member);
            return this.member;
        }
    }
}

