/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.converters;

import java.util.stream.Collectors;
import org.apache.geode.cache.configuration.DiskDirType;
import org.apache.geode.cache.configuration.DiskStoreType;
import org.apache.geode.management.configuration.DiskDir;
import org.apache.geode.management.configuration.DiskStore;
import org.apache.geode.management.internal.configuration.converters.ConfigurationConverter;

public class DiskStoreConverter
extends ConfigurationConverter<DiskStore, DiskStoreType> {
    @Override
    protected DiskStore fromNonNullXmlObject(DiskStoreType xmlObject) {
        DiskStore diskStore = new DiskStore();
        diskStore.setName(xmlObject.getName());
        if (xmlObject.isAllowForceCompaction() != null) {
            diskStore.setAllowForceCompaction(xmlObject.isAllowForceCompaction());
        }
        if (xmlObject.isAutoCompact() != null) {
            diskStore.setAutoCompact(xmlObject.isAutoCompact());
        }
        if (xmlObject.getCompactionThreshold() != null) {
            diskStore.setCompactionThreshold(Integer.valueOf(Integer.parseInt(xmlObject.getCompactionThreshold())));
        }
        if (xmlObject.getDiskUsageCriticalPercentage() != null) {
            diskStore.setDiskUsageCriticalPercentage(Float.valueOf(Float.parseFloat(xmlObject.getDiskUsageCriticalPercentage())));
        }
        if (xmlObject.getDiskUsageWarningPercentage() != null) {
            diskStore.setDiskUsageWarningPercentage(Float.valueOf(Float.parseFloat(xmlObject.getDiskUsageWarningPercentage())));
        }
        if (xmlObject.getMaxOplogSize() != null) {
            diskStore.setMaxOplogSizeInBytes(Long.valueOf(Long.parseLong(xmlObject.getMaxOplogSize())));
        }
        if (xmlObject.getQueueSize() != null) {
            diskStore.setQueueSize(Integer.valueOf(Integer.parseInt(xmlObject.getQueueSize())));
        }
        if (xmlObject.getTimeInterval() != null) {
            diskStore.setTimeInterval(Long.valueOf(Long.parseLong(xmlObject.getTimeInterval())));
        }
        if (xmlObject.getWriteBufferSize() != null) {
            diskStore.setWriteBufferSize(Integer.valueOf(Integer.parseInt(xmlObject.getWriteBufferSize())));
        }
        diskStore.setDirectories(xmlObject.getDiskDirs().stream().map(diskDirType -> {
            DiskDir diskDir = new DiskDir();
            if (diskDirType.getDirSize() != null) {
                diskDir.setDirSize(Integer.valueOf(Integer.parseInt(diskDirType.getDirSize())));
            }
            diskDir.setName(diskDirType.getContent());
            return diskDir;
        }).collect(Collectors.toList()));
        return diskStore;
    }

    @Override
    protected DiskStoreType fromNonNullConfigObject(DiskStore configObject) {
        DiskStoreType diskStoreType = new DiskStoreType();
        diskStoreType.setName(configObject.getName());
        if (configObject.isAllowForceCompaction() != null) {
            diskStoreType.setAllowForceCompaction(configObject.isAllowForceCompaction());
        }
        if (configObject.isAutoCompact() != null) {
            diskStoreType.setAutoCompact(configObject.isAutoCompact());
        }
        if (configObject.getCompactionThreshold() != null) {
            diskStoreType.setCompactionThreshold(configObject.getCompactionThreshold().toString());
        }
        if (configObject.getDiskUsageCriticalPercentage() != null) {
            diskStoreType.setDiskUsageCriticalPercentage(configObject.getDiskUsageCriticalPercentage().toString());
        }
        if (configObject.getDiskUsageWarningPercentage() != null) {
            diskStoreType.setDiskUsageWarningPercentage(configObject.getDiskUsageWarningPercentage().toString());
        }
        if (configObject.getMaxOplogSizeInBytes() != null) {
            diskStoreType.setMaxOplogSize(configObject.getMaxOplogSizeInBytes().toString());
        }
        if (configObject.getQueueSize() != null) {
            diskStoreType.setQueueSize(configObject.getQueueSize().toString());
        }
        if (configObject.getTimeInterval() != null) {
            diskStoreType.setTimeInterval(configObject.getTimeInterval().toString());
        }
        if (configObject.getWriteBufferSize() != null) {
            diskStoreType.setWriteBufferSize(configObject.getWriteBufferSize().toString());
        }
        diskStoreType.setDiskDirs(configObject.getDirectories().stream().map(diskDir -> {
            DiskDirType diskDirType = new DiskDirType();
            diskDirType.setContent(diskDir.getName());
            if (diskDir.getDirSize() != null) {
                diskDirType.setDirSize(diskDir.getDirSize().toString());
            }
            return diskDirType;
        }).collect(Collectors.toList()));
        return diskStoreType;
    }
}

