/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.internal.operation.OperationState;
import org.apache.geode.management.internal.operation.OperationStateStore;
import org.apache.geode.management.runtime.OperationResult;

@Experimental
public class OperationHistoryManager {
    private final long keepCompletedMillis;
    private final OperationStateStore operationStateStore;
    private final InternalCache cache;

    public OperationHistoryManager(OperationStateStore operationStateStore, InternalCache cache) {
        this(Duration.ofDays(7L), operationStateStore, cache);
    }

    public OperationHistoryManager(Duration keepCompleted, OperationStateStore operationStateStore, InternalCache cache) {
        this.keepCompletedMillis = keepCompleted.toMillis();
        this.operationStateStore = operationStateStore;
        this.cache = cache;
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationState<A, V> get(String opId) {
        this.expireHistory();
        return this.operationStateStore.get(opId);
    }

    @VisibleForTesting
    void expireHistory() {
        long expirationTime = this.now() - this.keepCompletedMillis;
        Set<String> expiredKeys = this.operationStateStore.list().stream().map(this::validateLocatorAndUpdateOperationState).filter(operationInstance -> OperationHistoryManager.isExpired(expirationTime, operationInstance)).map(OperationState::getId).collect(Collectors.toSet());
        expiredKeys.forEach(this.operationStateStore::remove);
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private static boolean isExpired(long expirationTime, OperationState<?, ?> operationInstance) {
        Date operationEnd = operationInstance.getOperationEnd();
        if (operationEnd == null) {
            return false;
        }
        return operationEnd.getTime() <= expirationTime;
    }

    private OperationState<?, ?> validateLocatorAndUpdateOperationState(OperationState<?, ?> operationState) {
        if (operationState.getOperationEnd() == null && this.isLocatorOffline(operationState)) {
            this.recordEnd(operationState.getId(), (OperationResult)operationState.getResult(), new RuntimeException("Locator that initiated the Rest API operation is offline: " + operationState.getLocator()));
        }
        return operationState;
    }

    private boolean isLocatorOffline(OperationState operationState) {
        return operationState.getLocator() != null && !this.cache.getMyId().toString().equals(operationState.getLocator()) && !this.cache.getDistributedSystem().getAllOtherMembers().stream().map(Object::toString).collect(Collectors.toSet()).contains(operationState.getLocator());
    }

    public String recordStart(ClusterManagementOperation<?> op, String locator) {
        this.expireHistory();
        return this.operationStateStore.recordStart(op, locator);
    }

    public void recordEnd(String opId, OperationResult result, Throwable cause) {
        this.operationStateStore.recordEnd(opId, result, cause);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> List<OperationState<A, V>> list(A opType) {
        this.expireHistory();
        return this.operationStateStore.list().stream().filter(instance -> opType.getClass().isAssignableFrom(instance.getOperation().getClass())).map(fi -> fi).collect(Collectors.toList());
    }
}

