/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.metrics.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.util.CollectingServiceLoader;
import org.apache.geode.internal.util.ListCollectingServiceLoader;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.metrics.MetricsPublishingService;
import org.apache.geode.metrics.internal.CloseableMeterBinder;
import org.apache.geode.metrics.internal.MetricsService;
import org.apache.geode.metrics.internal.StandardMeterBinder;
import org.apache.logging.log4j.Logger;

public class InternalDistributedSystemMetricsService
implements MetricsService {
    private final Logger logger;
    private final CompositeMeterRegistry meterRegistry;
    private final CollectingServiceLoader<MetricsPublishingService> publishingServiceLoader;
    private final Collection<MetricsPublishingService> publishingServices = new ArrayList<MetricsPublishingService>();
    private final CloseableMeterBinder binder;
    private final Set<MeterRegistry> persistentMeterRegistries = new HashSet<MeterRegistry>();
    private final MetricsService.Builder builder;

    @VisibleForTesting
    InternalDistributedSystemMetricsService(MetricsService.Builder builder, Logger logger, CollectingServiceLoader<MetricsPublishingService> publishingServiceLoader, CompositeMeterRegistry metricsServiceMeterRegistry, Collection<MeterRegistry> persistentMeterRegistries, CloseableMeterBinder binder, InternalDistributedSystem system, boolean isClient, boolean hasLocator, boolean hasCacheServer) {
        this.builder = builder;
        this.logger = logger;
        this.meterRegistry = metricsServiceMeterRegistry;
        this.publishingServiceLoader = publishingServiceLoader;
        this.binder = binder;
        this.persistentMeterRegistries.addAll(persistentMeterRegistries);
        this.addCommonTags(system, isClient, hasLocator, hasCacheServer);
    }

    @Override
    public void start() {
        this.persistentMeterRegistries.forEach(arg_0 -> ((CompositeMeterRegistry)this.meterRegistry).add(arg_0));
        this.binder.bindTo((MeterRegistry)this.meterRegistry);
        this.publishingServices.addAll(this.publishingServiceLoader.loadServices(MetricsPublishingService.class));
        this.publishingServices.forEach(this::startMetricsPublishingService);
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public MetricsService.Builder getRebuilder() {
        return this.builder;
    }

    @Override
    public void stop() {
        this.closeMeterBinder();
        this.clearAndCloseMeterRegistry();
    }

    @Override
    public void addSubregistry(MeterRegistry subregistry) {
        this.meterRegistry.add(subregistry);
    }

    @Override
    public void removeSubregistry(MeterRegistry subregistry) {
        this.meterRegistry.remove(subregistry);
    }

    private void addCommonTags(InternalDistributedSystem system, boolean isClient, boolean hasLocators, boolean hasCacheServer) {
        int clusterId = system.getConfig().getDistributedSystemId();
        String memberName = system.getName();
        String hostName = system.getDistributedMember().getHost();
        Objects.requireNonNull(memberName, "Member Name is null.");
        Objects.requireNonNull(hostName, "Host Name is null.");
        if (hostName.isEmpty()) {
            throw new IllegalArgumentException("Host name must not be empty");
        }
        HashSet<Tag> tags = new HashSet<Tag>();
        if (!isClient) {
            tags.add(Tag.of((String)"cluster", (String)String.valueOf(clusterId)));
        }
        if (!memberName.isEmpty()) {
            tags.add(Tag.of((String)"member", (String)memberName));
        }
        tags.add(Tag.of((String)"host", (String)hostName));
        tags.add(Tag.of((String)"member.type", (String)InternalDistributedSystemMetricsService.memberTypeFor(hasLocators, hasCacheServer)));
        this.meterRegistry.config().commonTags(tags);
    }

    private static String memberTypeFor(boolean hasLocator, boolean hasCacheServer) {
        if (hasCacheServer && hasLocator) {
            return "server-locator";
        }
        if (hasCacheServer) {
            return "server";
        }
        if (hasLocator) {
            return "locator";
        }
        return "embedded-cache";
    }

    private void startMetricsPublishingService(MetricsPublishingService service) {
        try {
            service.start(this);
        }
        catch (Exception thrown) {
            this.logger.error("Exception while starting metrics publishing service " + service.getClass().getName(), (Throwable)thrown);
        }
    }

    private void stopMetricsPublishingService(MetricsPublishingService service) {
        try {
            service.stop(this);
        }
        catch (Exception thrown) {
            this.logger.error("Exception while stopping metrics publishing service " + service.getClass().getName(), (Throwable)thrown);
        }
    }

    private void closeMeterBinder() {
        try {
            this.binder.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearAndCloseMeterRegistry() {
        if (this.meterRegistry != null) {
            this.publishingServices.forEach(this::stopMetricsPublishingService);
            this.publishingServices.clear();
            new HashSet(this.meterRegistry.getRegistries()).forEach(arg_0 -> ((CompositeMeterRegistry)this.meterRegistry).remove(arg_0));
            this.meterRegistry.clear();
            this.meterRegistry.close();
        }
    }

    public static class Builder
    implements MetricsService.Builder {
        private boolean isClient = false;
        private Supplier<Logger> loggerSupplier = LogService::getLogger;
        private Supplier<CloseableMeterBinder> meterBinderSupplier = StandardMeterBinder::new;
        private Factory metricsServiceFactory = InternalDistributedSystemMetricsService::new;
        private Supplier<CompositeMeterRegistry> compositeRegistrySupplier = CompositeMeterRegistry::new;
        private Supplier<CollectingServiceLoader<MetricsPublishingService>> serviceLoaderSupplier = ListCollectingServiceLoader::new;
        private final Set<MeterRegistry> persistentMeterRegistries = new HashSet<MeterRegistry>();
        private BooleanSupplier hasLocator = Locator::hasLocator;
        private BooleanSupplier hasCacheServer = () -> ServerLauncher.getInstance() != null;

        @Override
        public MetricsService build(InternalDistributedSystem system) {
            return this.metricsServiceFactory.create(this, this.loggerSupplier.get(), this.serviceLoaderSupplier.get(), this.compositeRegistrySupplier.get(), this.persistentMeterRegistries, this.meterBinderSupplier.get(), system, this.isClient, this.hasLocator.getAsBoolean(), this.hasCacheServer.getAsBoolean());
        }

        @Override
        public Builder addPersistentMeterRegistry(MeterRegistry registry) {
            this.persistentMeterRegistries.add(registry);
            return this;
        }

        @Override
        public Builder addPersistentMeterRegistries(Collection<MeterRegistry> registries) {
            this.persistentMeterRegistries.addAll(registries);
            return this;
        }

        @Override
        public MetricsService.Builder setIsClient(boolean isClient) {
            this.isClient = isClient;
            return this;
        }

        @VisibleForTesting
        Builder setBinder(CloseableMeterBinder binder) {
            this.meterBinderSupplier = () -> binder;
            return this;
        }

        @VisibleForTesting
        Builder setCacheServerDetector(BooleanSupplier hasCacheServer) {
            this.hasCacheServer = hasCacheServer;
            return this;
        }

        @VisibleForTesting
        Builder setCompositeMeterRegistry(CompositeMeterRegistry registry) {
            this.compositeRegistrySupplier = () -> registry;
            return this;
        }

        @VisibleForTesting
        Builder setLocatorDetector(BooleanSupplier hasLocator) {
            this.hasLocator = hasLocator;
            return this;
        }

        @VisibleForTesting
        Builder setLogger(Logger logger) {
            this.loggerSupplier = () -> logger;
            return this;
        }

        @VisibleForTesting
        Builder setMetricsServiceFactory(Factory factory) {
            this.metricsServiceFactory = factory;
            return this;
        }

        @VisibleForTesting
        Builder setServiceLoader(CollectingServiceLoader<MetricsPublishingService> serviceLoader) {
            this.serviceLoaderSupplier = () -> serviceLoader;
            return this;
        }
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface Factory {
        public MetricsService create(MetricsService.Builder var1, Logger var2, CollectingServiceLoader<MetricsPublishingService> var3, CompositeMeterRegistry var4, Collection<MeterRegistry> var5, CloseableMeterBinder var6, InternalDistributedSystem var7, boolean var8, boolean var9, boolean var10);
    }
}

