/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.json.JsonHelper;

public class PdxToJSON {
    @MutableForTesting
    public static boolean PDXTOJJSON_UNQUOTEFIELDNAMES = Boolean.getBoolean("pdxToJson.unQuoteFieldNames");
    private final PdxInstance m_pdxInstance;

    public PdxToJSON(PdxInstance pdx) {
        this.m_pdxInstance = pdx;
    }

    public String getJSON() {
        JsonFactory jf = new JsonFactory();
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(KnownVersion.CURRENT);){
            JsonGenerator jg = jf.createJsonGenerator((OutputStream)((Object)hdos), JsonEncoding.UTF8);
            this.enableDisableJSONGeneratorFeature(jg);
            this.getJSONString(jg, this.m_pdxInstance);
            jg.close();
            String string = new String(hdos.toByteArray());
            return string;
        }
    }

    public byte[] getJSONByteArray() {
        JsonFactory jf = new JsonFactory();
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(KnownVersion.CURRENT);){
            JsonGenerator jg = jf.createJsonGenerator((OutputStream)((Object)hdos), JsonEncoding.UTF8);
            this.enableDisableJSONGeneratorFeature(jg);
            this.getJSONString(jg, this.m_pdxInstance);
            jg.close();
            byte[] byArray = hdos.toByteArray();
            return byArray;
        }
    }

    private void enableDisableJSONGeneratorFeature(JsonGenerator jg) {
        jg.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
        jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        if (PDXTOJJSON_UNQUOTEFIELDNAMES) {
            jg.disable(JsonGenerator.Feature.QUOTE_FIELD_NAMES);
        }
    }

    protected String convertPdxToJson(PdxInstance pdxObj) {
        return pdxObj != null ? JSONFormatter.toJSON(pdxObj) : null;
    }

    @VisibleForTesting
    protected void writeValue(JsonGenerator jg, Object value, String pf) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else if (value.getClass().equals(Boolean.class)) {
            boolean b = (Boolean)value;
            jg.writeBoolean(b);
        } else if (value.getClass().equals(Byte.class)) {
            Byte b = (Byte)value;
            jg.writeNumber((short)b.byteValue());
        } else if (value.getClass().equals(Short.class)) {
            Short b = (Short)value;
            jg.writeNumber(b.shortValue());
        } else if (value.getClass().equals(Integer.class)) {
            int i = (Integer)value;
            jg.writeNumber(i);
        } else if (value.getClass().equals(Long.class)) {
            long i = (Long)value;
            jg.writeNumber(i);
        } else if (value.getClass().equals(BigInteger.class)) {
            BigInteger i = (BigInteger)value;
            jg.writeNumber(i);
        } else if (value.getClass().equals(Float.class)) {
            float i = ((Float)value).floatValue();
            jg.writeNumber(i);
        } else if (value.getClass().equals(BigDecimal.class)) {
            BigDecimal i = (BigDecimal)value;
            jg.writeNumber(i);
        } else if (value.getClass().equals(Double.class)) {
            double d = (Double)value;
            jg.writeNumber(d);
        } else if (value.getClass().equals(String.class)) {
            String s = (String)value;
            jg.writeString(s);
        } else if (value.getClass().isArray()) {
            this.getJSONStringFromArray(jg, value, pf);
        } else if (value.getClass().equals(EnumInfo.class)) {
            jg.writeString(value.toString());
        } else if (value.getClass().equals(EnumInfo.PdxInstanceEnumInfo.class)) {
            jg.writeString(value.toString());
        } else if (value instanceof PdxInstance) {
            this.getJSONString(jg, (PdxInstance)value);
        } else if (value instanceof Collection) {
            this.getJSONStringFromCollection(jg, (Collection)value, pf);
        } else if (value instanceof Map) {
            this.getJSONStringFromMap(jg, (Map)value, pf);
        } else {
            throw new IllegalStateException("The pdx field " + pf + " has a value " + value + " whose type " + value.getClass() + " can not be converted to JSON.");
        }
    }

    private void getJSONStringFromMap(JsonGenerator jg, Map map, String pf) throws IOException {
        jg.writeStartObject();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            jg.writeFieldName(entry.getKey().toString());
            this.writeValue(jg, entry.getValue(), pf);
        }
        jg.writeEndObject();
    }

    private String getJSONString(JsonGenerator jg, PdxInstance pdxInstance) throws IOException {
        jg.writeStartObject();
        List<String> pdxFields = pdxInstance.getFieldNames();
        for (String pf : pdxFields) {
            Object value = pdxInstance.getField(pf);
            jg.writeFieldName(pf);
            this.writeValue(jg, value, pf);
        }
        jg.writeEndObject();
        return null;
    }

    @VisibleForTesting
    protected void getJSONStringFromArray(JsonGenerator jg, Object value, String pf) throws IOException {
        if (!value.getClass().isArray()) {
            throw new IllegalStateException("Expected an array for pdx field " + pf + ", but got an object of type " + value.getClass());
        }
        if (value.getClass().getName().equals("[Z")) {
            JsonHelper.getJsonFromPrimitiveBoolArray(jg, (boolean[])value, pf);
        } else if (value.getClass().getName().equals("[B")) {
            JsonHelper.getJsonFromPrimitiveByteArray(jg, (byte[])value, pf);
        } else if (value.getClass().getName().equals("[S")) {
            JsonHelper.getJsonFromPrimitiveShortArray(jg, (short[])value, pf);
        } else if (value.getClass().getName().equals("[I")) {
            JsonHelper.getJsonFromPrimitiveIntArray(jg, (int[])value, pf);
        } else if (value.getClass().getName().equals("[J")) {
            JsonHelper.getJsonFromPrimitiveLongArray(jg, (long[])value, pf);
        } else if (value.getClass().getName().equals("[F")) {
            JsonHelper.getJsonFromPrimitiveFloatArray(jg, (float[])value, pf);
        } else if (value.getClass().getName().equals("[D")) {
            JsonHelper.getJsonFromPrimitiveDoubleArray(jg, (double[])value, pf);
        } else if (value.getClass().equals(Boolean[].class)) {
            JsonHelper.getJsonFromWrapperBoolArray(jg, (Boolean[])value, pf);
        } else if (value.getClass().equals(Byte[].class)) {
            JsonHelper.getJsonFromWrapperByteArray(jg, (Byte[])value, pf);
        } else if (value.getClass().equals(Short[].class)) {
            JsonHelper.getJsonFromWrapperShortArray(jg, (Short[])value, pf);
        } else if (value.getClass().equals(Integer[].class)) {
            JsonHelper.getJsonFromWrapperIntArray(jg, (Integer[])value, pf);
        } else if (value.getClass().equals(Long[].class)) {
            JsonHelper.getJsonFromWrapperLongArray(jg, (Long[])value, pf);
        } else if (value.getClass().equals(Float[].class)) {
            JsonHelper.getJsonFromWrapperFloatArray(jg, (Float[])value, pf);
        } else if (value.getClass().equals(Double[].class)) {
            JsonHelper.getJsonFromWrapperDoubleArray(jg, (Double[])value, pf);
        } else if (value.getClass().equals(BigInteger[].class)) {
            JsonHelper.getJsonFromBigIntArray(jg, (BigInteger[])value, pf);
        } else if (value.getClass().equals(BigDecimal[].class)) {
            JsonHelper.getJsonFromBigDecimalArray(jg, (BigDecimal[])value, pf);
        } else if (value.getClass().equals(String[].class)) {
            JsonHelper.getJsonFromStringArray(jg, (String[])value, pf);
        } else if (value.getClass().equals(Object[].class)) {
            Object[] array;
            jg.writeStartArray();
            for (Object obj : array = (Object[])value) {
                this.writeValue(jg, obj, pf);
            }
            jg.writeEndArray();
        } else {
            throw new IllegalStateException("The pdx field " + pf + " is an array whose component type " + value.getClass().getComponentType() + " can not be converted to JSON.");
        }
    }

    private void getJSONStringFromCollection(JsonGenerator jg, Collection<?> coll, String pf) throws IOException {
        jg.writeStartArray();
        for (Object obj : coll) {
            this.writeValue(jg, obj, pf);
        }
        jg.writeEndArray();
    }
}

