/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.util.CollectionUtils;

@Immutable
public class ResourcePermission
extends WildcardPermission {
    public static final String ALL = "*";
    public static final String NULL = "NULL";
    @Deprecated
    public static final String ALL_REGIONS = "*";
    @Deprecated
    public static final String ALL_KEYS = "*";
    private String resource = "NULL";
    private String operation = "NULL";
    private String target = "*";
    private String key = "*";

    public ResourcePermission() {
        this.setParts(Arrays.asList(Collections.singleton(this.resource), Collections.singleton(this.operation), Collections.singleton(this.target), Collections.singleton(this.key)));
    }

    public ResourcePermission(Resource resource, Operation operation) {
        this(resource, operation, "*", "*");
    }

    public ResourcePermission(Resource resource, Operation operation, String target) {
        this(resource, operation, target, "*");
    }

    public ResourcePermission(Resource resource, Operation operation, Target target) {
        this(resource, operation, target, "*");
    }

    public ResourcePermission(Resource resource, Operation operation, Target target, String key) {
        this.init(resource == null ? NULL : resource.getName(), operation == null ? NULL : operation.getName(), target == null ? null : target.getName(), key);
    }

    public ResourcePermission(Resource resource, Operation operation, String target, String key) {
        this.init(resource == null ? NULL : resource.getName(), operation == null ? NULL : operation.getName(), this.parseTarget(target), key);
    }

    private String parseTarget(String target) {
        return target == null ? null : StringUtils.stripStart((String)target, (String)"/");
    }

    public ResourcePermission(String resource, String operation) {
        this(resource, operation, "*", "*");
    }

    public ResourcePermission(String resource, String operation, String target) {
        this(resource, operation, target, "*");
    }

    public ResourcePermission(String resource, String operation, String target, String key) {
        this.init(this.parsePart(resource, r -> Resource.valueOf(r).getName()), this.parsePart(operation, o -> Operation.valueOf(o).getName()), this.parseTarget(target), key);
    }

    private void init(String resource, String operation, String target, String key) {
        this.resource = resource;
        this.operation = operation;
        if (target != null) {
            this.target = target;
        }
        if (key != null) {
            this.key = key;
        }
        this.setParts(Arrays.asList(Collections.singleton(this.resource), Collections.singleton(this.operation), CollectionUtils.asSet((Object[])this.target.split(",")), CollectionUtils.asSet((Object[])this.key.split(","))));
    }

    private String parsePart(String part, UnaryOperator<String> operator) {
        if (part == null) {
            return NULL;
        }
        if (part.equals("*")) {
            return "*";
        }
        return (String)operator.apply(part.toUpperCase());
    }

    public Resource getResource() {
        if ("*".equals(this.resource)) {
            return Resource.ALL;
        }
        return Resource.valueOf(this.resource);
    }

    public Operation getOperation() {
        if ("*".equals(this.operation)) {
            return Operation.ALL;
        }
        return Operation.valueOf(this.operation);
    }

    public String getResourceString() {
        return this.resource;
    }

    public String getOperationString() {
        return this.operation;
    }

    public String getTarget() {
        return this.target;
    }

    @Deprecated
    public String getRegionName() {
        return this.getTarget();
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(this.resource, this.operation, this.target, this.key));
        if ("*".equals(this.key)) {
            parts.remove(3);
            if ("*".equals(this.target)) {
                parts.remove(2);
                if ("*".equals(this.operation)) {
                    parts.remove(1);
                }
            }
        }
        return parts.stream().collect(Collectors.joining(":"));
    }

    public static enum Target {
        ALL,
        DISK,
        GATEWAY,
        QUERY,
        DEPLOY;


        public String getName() {
            if (this == ALL) {
                return "*";
            }
            return this.name();
        }
    }

    public static enum Operation {
        ALL,
        NULL,
        MANAGE,
        WRITE,
        READ;


        public String getName() {
            if (this == ALL) {
                return "*";
            }
            return this.name();
        }
    }

    public static enum Resource {
        ALL,
        NULL,
        CLUSTER,
        DATA;


        public String getName() {
            if (this == ALL) {
                return "*";
            }
            return this.name();
        }
    }
}

