/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.LuceneResultStruct;
import org.apache.geode.cache.lucene.PageableLuceneQueryResults;
import org.apache.geode.cache.lucene.internal.LuceneResultStructImpl;
import org.apache.geode.cache.lucene.internal.distributed.EntryScore;
import org.apache.geode.cache.lucene.internal.results.LuceneGetPageFunction;
import org.apache.geode.cache.lucene.internal.results.MapResultCollector;

public class PageableLuceneQueryResultsImpl<K, V>
implements PageableLuceneQueryResults<K, V> {
    private final List<EntryScore<K>> hits;
    private List<LuceneResultStruct<K, V>> currentPage;
    private float maxScore = Float.MIN_VALUE;
    private final Region<K, V> userRegion;
    private int currentHit = 0;
    private final int pageSize;

    public PageableLuceneQueryResultsImpl(List<EntryScore<K>> hits, Region<K, V> userRegion, int pageSize) {
        this.hits = hits;
        this.userRegion = userRegion;
        this.pageSize = pageSize == 0 ? Integer.MAX_VALUE : pageSize;
    }

    public List<LuceneResultStruct<K, V>> getHitEntries(int fromIndex, int toIndex) {
        ArrayList<LuceneResultStruct<K, V>> results = null;
        try {
            List<EntryScore<K>> scores = this.hits.subList(fromIndex, toIndex);
            HashSet<K> keys = new HashSet<K>(scores.size());
            for (EntryScore<K> score : scores) {
                keys.add(score.getKey());
            }
            Map values = this.getValues(keys);
            results = new ArrayList<LuceneResultStruct<K, V>>(values.size());
            for (EntryScore<K> score : scores) {
                V value = values.get(score.getKey());
                if (value == null) continue;
                results.add(new LuceneResultStructImpl<K, V>(score.getKey(), value, score.getScore()));
            }
        }
        catch (FunctionException functionException) {
            if (functionException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)functionException.getCause();
            }
            throw functionException;
        }
        return results;
    }

    protected Map<K, V> getValues(Set<K> keys) {
        ResultCollector resultCollector = this.onRegion().withFilter(keys).withCollector((ResultCollector)new MapResultCollector()).execute(LuceneGetPageFunction.ID);
        return (Map)resultCollector.getResult();
    }

    protected Execution onRegion() {
        return FunctionService.onRegion(this.userRegion);
    }

    @Override
    public List<LuceneResultStruct<K, V>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<LuceneResultStruct<K, V>> result = this.advancePage();
        this.currentPage = null;
        return result;
    }

    private List<LuceneResultStruct<K, V>> advancePage() {
        if (this.currentPage != null) {
            return this.currentPage;
        }
        int resultSize = this.pageSize != Integer.MAX_VALUE ? this.pageSize : this.hits.size();
        this.currentPage = new ArrayList<LuceneResultStruct<K, V>>(resultSize);
        while (this.currentPage.size() < this.pageSize && this.currentHit < this.hits.size()) {
            int end = this.currentHit + this.pageSize - this.currentPage.size();
            end = end > this.hits.size() ? this.hits.size() : end;
            this.currentPage.addAll(this.getHitEntries(this.currentHit, end));
            this.currentHit = end;
        }
        return this.currentPage;
    }

    @Override
    public boolean hasNext() {
        this.advancePage();
        return !this.currentPage.isEmpty();
    }

    @Override
    public int size() {
        return this.hits.size();
    }

    @Override
    public float getMaxScore() {
        if (this.maxScore == Float.MIN_VALUE) {
            for (EntryScore<K> score : this.hits) {
                this.maxScore = Math.max(this.maxScore, score.getScore());
            }
        }
        return this.maxScore;
    }
}

