/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.snappy;

import java.util.Arrays;
import java.util.Objects;
import org.iq80.snappy.CorruptionException;
import org.iq80.snappy.SnappyRawCompressor;
import org.iq80.snappy.SnappyRawDecompressor;
import sun.misc.Unsafe;

public final class Snappy {
    private Snappy() {
    }

    public static int getUncompressedLength(byte[] compressed, int compressedOffset) throws CorruptionException {
        long compressedAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressedOffset;
        long compressedLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressed.length;
        return SnappyRawDecompressor.getUncompressedLength(compressed, compressedAddress, compressedLimit);
    }

    public static byte[] uncompress(byte[] compressed, int compressedOffset, int compressedSize) throws CorruptionException {
        byte[] output = new byte[Snappy.getUncompressedLength(compressed, compressedOffset)];
        int uncompressedSize = Snappy.uncompress(compressed, compressedOffset, compressedSize, output, 0);
        if (uncompressedSize != output.length) {
            throw new CorruptionException(0L, String.format("Recorded length is %s bytes but actual length after decompression is %s bytes ", output.length, uncompressedSize));
        }
        return output;
    }

    public static int uncompress(byte[] compressed, int compressedOffset, int compressedSize, byte[] uncompressed, int uncompressedOffset) throws CorruptionException {
        return Snappy.uncompress(compressed, compressedOffset, compressedSize, uncompressed, uncompressedOffset, uncompressed.length - uncompressedOffset);
    }

    public static int uncompress(byte[] compressed, int compressedOffset, int compressedSize, byte[] uncompressed, int uncompressedOffset, int uncompressedLength) {
        Snappy.verifyRange(compressed, compressedOffset, compressedSize);
        Snappy.verifyRange(uncompressed, uncompressedOffset, uncompressedLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressedOffset;
        long inputLimit = inputAddress + (long)compressedSize;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + uncompressedOffset;
        long outputLimit = outputAddress + (long)uncompressed.length - (long)uncompressedOffset;
        return SnappyRawDecompressor.decompress(compressed, inputAddress, inputLimit, uncompressed, outputAddress, outputLimit);
    }

    public static int maxCompressedLength(int sourceLength) {
        return SnappyRawCompressor.maxCompressedLength(sourceLength);
    }

    public static int compress(byte[] uncompressed, int uncompressedOffset, int uncompressedLength, byte[] compressed, int compressedOffset) {
        return Snappy.compress(new CompressionContext(), uncompressed, uncompressedOffset, uncompressedLength, compressed, compressedOffset, compressed.length - compressedOffset);
    }

    public static int compress(CompressionContext context, byte[] uncompressed, int uncompressedOffset, int uncompressedLength, byte[] compressed, int compressedOffset, int maxCompressedLength) {
        Snappy.verifyRange(uncompressed, uncompressedOffset, uncompressedLength);
        Snappy.verifyRange(compressed, compressedOffset, maxCompressedLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + uncompressedOffset;
        long inputLimit = inputAddress + (long)uncompressedLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressedOffset;
        long outputLimit = outputAddress + (long)maxCompressedLength;
        return SnappyRawCompressor.compress(uncompressed, inputAddress, inputLimit, compressed, outputAddress, outputLimit, context.getTable());
    }

    public static byte[] compress(byte[] data) {
        byte[] compressedOut = new byte[Snappy.maxCompressedLength(data.length)];
        int compressedSize = Snappy.compress(data, 0, data.length, compressedOut, 0);
        byte[] trimmedBuffer = Arrays.copyOf(compressedOut, compressedSize);
        return trimmedBuffer;
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }

    public static final class CompressionContext {
        private final short[] table = new short[16384];

        private short[] getTable() {
            return this.table;
        }
    }
}

