/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import org.springframework.shell.table.TableModel;
import org.springframework.util.Assert;

public class ArrayTableModel
extends TableModel {
    private Object[][] data;

    public ArrayTableModel(Object[][] data) {
        this.data = data;
        int width = data.length > 0 ? data[0].length : 0;
        for (int row = 0; row < data.length; ++row) {
            Assert.isTrue((width == data[row].length ? 1 : 0) != 0, (String)"All rows of array data must be of same length");
        }
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.data.length > 0 ? this.data[0].length : 0;
    }

    @Override
    public Object getValue(int row, int column) {
        return this.data[row][column];
    }
}

