/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.internal.serialization.filter.ApiPackage;
import org.apache.geode.internal.serialization.filter.Java9ReflectiveObjectInputFilterApi;
import org.apache.geode.internal.serialization.filter.ObjectInputFilterApi;
import org.apache.geode.internal.serialization.filter.ObjectInputFilterApiFactory;
import org.apache.geode.internal.serialization.filter.ObjectInputFilterUtils;
import org.apache.geode.internal.serialization.filter.ReflectiveObjectInputFilterApi;

public class ReflectiveObjectInputFilterApiFactory
implements ObjectInputFilterApiFactory {
    @Override
    public ObjectInputFilterApi createObjectInputFilterApi() {
        try {
            if (SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_9)) {
                return new Java9ReflectiveObjectInputFilterApi(ApiPackage.JAVA_IO);
            }
            if (SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_1_8)) {
                return new ReflectiveObjectInputFilterApi(ApiPackage.SUN_MISC);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            ObjectInputFilterUtils.throwUnsupportedOperationException(e);
        }
        ObjectInputFilterUtils.throwUnsupportedOperationException();
        return null;
    }
}

