/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.management.remote.TargetedNotification;

public class NotificationResult
implements Serializable {
    private static final long serialVersionUID = 1191800228721395279L;
    private final long earliestSequenceNumber;
    private final long nextSequenceNumber;
    private final TargetedNotification[] targetedNotifications;

    public NotificationResult(long earliestSequenceNumber, long nextSequenceNumber, TargetedNotification[] targetedNotifications) {
        if (earliestSequenceNumber < 0L) {
            throw new IllegalArgumentException("Earliest sequence number cannot be negative");
        }
        if (nextSequenceNumber < 0L) {
            throw new IllegalArgumentException("Next sequence number cannot be negative");
        }
        if (targetedNotifications == null) {
            throw new IllegalArgumentException("TargetedNotification array cannot be null");
        }
        this.earliestSequenceNumber = earliestSequenceNumber;
        this.nextSequenceNumber = nextSequenceNumber;
        this.targetedNotifications = targetedNotifications;
    }

    public long getEarliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    public long getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public TargetedNotification[] getTargetedNotifications() {
        return this.targetedNotifications;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("NotificationResult[earliest=");
        buffer.append(this.getEarliestSequenceNumber()).append(", next=");
        buffer.append(this.getNextSequenceNumber()).append(", notifications=");
        TargetedNotification[] notifs = this.getTargetedNotifications();
        List<TargetedNotification> list = notifs == null ? null : Arrays.asList(notifs);
        buffer.append(list).append("]");
        return buffer.toString();
    }
}

