/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal.executors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.executors.LoggingThreadFactory;
import org.apache.geode.logging.internal.executors.LoggingUncaughtExceptionHandler;

public class LoggingExecutors {
    public static ExecutorService newCachedThreadPool(String threadName, boolean isDaemon) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, workQueue, threadFactory);
    }

    public static ThreadPoolExecutor newFixedThreadPool(int poolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String threadName, boolean isDaemon) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    private static ThreadPoolExecutor newFixedThreadPool(int poolSize, long keepAliveTime, TimeUnit unit, String threadName, boolean isDaemon) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        return LoggingExecutors.newFixedThreadPool(poolSize, keepAliveTime, unit, workQueue, threadName, isDaemon);
    }

    public static ExecutorService newFixedThreadPool(int poolSize, String threadName, boolean isDaemon) {
        return LoggingExecutors.newFixedThreadPool(poolSize, 0L, TimeUnit.SECONDS, threadName, isDaemon);
    }

    public static ExecutorService newFixedThreadPoolWithFeedSize(int poolSize, int workQueueSize, String threadName) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(workQueueSize);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(poolSize, poolSize, 10L, TimeUnit.SECONDS, workQueue, threadFactory, rejectedExecutionHandler);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ExecutorService newFixedThreadPoolWithTimeout(int poolSize, int keepAliveTime, TimeUnit unit, String threadName) {
        return LoggingExecutors.newFixedThreadPool(poolSize, keepAliveTime, unit, threadName, true);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, String threadName) {
        return LoggingExecutors.newScheduledThreadPool(poolSize, threadName, true);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, String threadName, boolean executeDelayedTasks) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(poolSize, threadFactory);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(executeDelayedTasks);
        return executor;
    }

    public static ExecutorService newSingleThreadExecutor(String threadName, boolean isDaemon) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, workQueue, threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String threadName) {
        return LoggingExecutors.newScheduledThreadPool(1, threadName);
    }

    public static Executor newThreadOnEachExecute(String threadName) {
        return command -> new LoggingThread(threadName, command).start();
    }

    public static ExecutorService newWorkStealingPool(String threadName, int maximumParallelThreads) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            LoggingUncaughtExceptionHandler.setOnThread(worker);
            worker.setName(threadName + worker.getPoolIndex());
            return worker;
        };
        return new ForkJoinPool(maximumParallelThreads, factory, null, true);
    }
}

