/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mx4j.tools.adaptor.http.CommandProcessorUtil;
import mx4j.tools.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.tools.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateMBeanCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        Element root = document.createElement("MBeanOperation");
        document.appendChild(root);
        Element operationElement = document.createElement("Operation");
        operationElement.setAttribute("name", "create");
        root.appendChild(operationElement);
        String objectVariable = in.getVariable("objectname");
        String classVariable = in.getVariable("class");
        if (objectVariable == null || objectVariable.equals("") || classVariable == null || classVariable.equals("")) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
            return document;
        }
        operationElement.setAttribute("objectname", objectVariable);
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        boolean unmatchedParameters = false;
        boolean valid = false;
        do {
            String parameterType = in.getVariable("type" + i);
            String parameterValue = in.getVariable("value" + i);
            boolean bl = valid = parameterType != null && parameterValue != null;
            if (valid) {
                types.add(parameterType);
                Object value = null;
                try {
                    value = CommandProcessorUtil.createParameterValue(parameterType, parameterValue);
                }
                catch (Exception e) {
                    operationElement.setAttribute("result", "error");
                    operationElement.setAttribute("errorMsg", "Parameter " + i + ": " + parameterValue + " cannot be converted to type " + parameterType);
                    return document;
                }
                if (value != null) {
                    values.add(value);
                }
            }
            if (parameterType == null ^ parameterValue == null) {
                unmatchedParameters = true;
                break;
            }
            ++i;
        } while (valid);
        if (objectVariable == null || objectVariable.equals("")) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
            return document;
        }
        if (unmatchedParameters) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "count of parameter types doesn't match count of parameter values");
            return document;
        }
        ObjectName name = null;
        try {
            name = new ObjectName(objectVariable);
        }
        catch (MalformedObjectNameException e) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "Malformed object name");
            return document;
        }
        if (this.server.isRegistered(name)) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "A MBean with name " + name + " is already registered");
            return document;
        }
        try {
            if (types.size() > 0) {
                Object[] params = values.toArray();
                String[] signature = new String[types.size()];
                types.toArray(signature);
                this.server.createMBean(classVariable, name, null, params, signature);
            } else {
                this.server.createMBean(classVariable, name, null);
            }
            operationElement.setAttribute("result", "success");
        }
        catch (Exception e) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", e.getMessage());
        }
        return document;
    }
}

