/*
 * Decompiled with CFR 0.152.
 */
package mx4j.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class Utils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static Class loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("null");
        }
        if ((name = name.trim()).equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("java.lang.String")) {
            return class$java$lang$String == null ? (class$java$lang$String = Utils.class$("java.lang.String")) : class$java$lang$String;
        }
        if (name.equals("java.lang.Object")) {
            return class$java$lang$Object == null ? (class$java$lang$Object = Utils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (name.startsWith("[")) {
            int dimension = 0;
            while (name.charAt(dimension) == '[') {
                ++dimension;
            }
            char type = name.charAt(dimension);
            Class cls = null;
            switch (type) {
                case 'Z': {
                    cls = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    cls = Byte.TYPE;
                    break;
                }
                case 'C': {
                    cls = Character.TYPE;
                    break;
                }
                case 'S': {
                    cls = Short.TYPE;
                    break;
                }
                case 'I': {
                    cls = Integer.TYPE;
                    break;
                }
                case 'J': {
                    cls = Long.TYPE;
                    break;
                }
                case 'F': {
                    cls = Float.TYPE;
                    break;
                }
                case 'D': {
                    cls = Double.TYPE;
                    break;
                }
                case 'L': {
                    String n = name.substring(dimension + 1, name.length() - 1);
                    cls = Utils.loadClass(loader, n);
                }
            }
            if (cls == null) {
                throw new ClassNotFoundException(name);
            }
            int[] dim = new int[dimension];
            return Array.newInstance(cls, dim).getClass();
        }
        if (loader != null) {
            return loader.loadClass(name);
        }
        return Class.forName(name, false, null);
    }

    public static Class[] loadClasses(ClassLoader loader, String[] names) throws ClassNotFoundException {
        int n = names.length;
        Class[] cls = new Class[n];
        for (int i = 0; i < n; ++i) {
            String name = names[i];
            cls[i] = Utils.loadClass(loader, name);
        }
        return cls;
    }

    public static boolean isAttributeGetter(Method m) {
        if (m == null) {
            return false;
        }
        String name = m.getName();
        Class<?> retType = m.getReturnType();
        Class<?>[] params = m.getParameterTypes();
        if (retType != Void.TYPE && params.length == 0) {
            if (name.startsWith("get") && name.length() > 3) {
                return true;
            }
            if (name.startsWith("is") && name.length() > 2 && retType == Boolean.TYPE) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAttributeSetter(Method m) {
        if (m == null) {
            return false;
        }
        String name = m.getName();
        Class<?> retType = m.getReturnType();
        Class<?>[] params = m.getParameterTypes();
        return retType == Void.TYPE && params.length == 1 && name.startsWith("set") && name.length() > 3;
    }

    public static boolean wildcardMatch(String pattern, String string) {
        int stringLength = string.length();
        int stringIndex = 0;
        for (int patternIndex = 0; patternIndex < pattern.length(); ++patternIndex) {
            char c = pattern.charAt(patternIndex);
            if (c == '*') {
                while (stringIndex < stringLength) {
                    if (Utils.wildcardMatch(pattern.substring(patternIndex + 1), string.substring(stringIndex))) {
                        return true;
                    }
                    ++stringIndex;
                }
                continue;
            }
            if (c == '?') {
                if (++stringIndex <= stringLength) continue;
                return false;
            }
            if (stringIndex >= stringLength || c != string.charAt(stringIndex)) {
                return false;
            }
            ++stringIndex;
        }
        return stringIndex == stringLength;
    }

    public static boolean arrayEquals(Object[] arr1, Object[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null ^ arr2 == null) {
            return false;
        }
        if (!arr1.getClass().equals(arr2.getClass())) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            Object obj2;
            Object obj1 = arr1[i];
            if (obj1 == null ^ (obj2 = arr2[i]) == null) {
                return false;
            }
            if (obj1 == null || obj1.equals(obj2)) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayEquals(byte[] arr1, byte[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null ^ arr2 == null) {
            return false;
        }
        if (!arr1.getClass().equals(arr2.getClass())) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            byte b1 = arr1[i];
            byte b2 = arr2[i];
            if (b1 == b2) continue;
            return false;
        }
        return true;
    }

    public static int arrayHashCode(Object[] arr) {
        int hash = 0;
        if (arr != null) {
            hash ^= arr.getClass().hashCode();
            for (int i = 0; i < arr.length; ++i) {
                hash ^= arr[i] == null ? 0 : arr[i].hashCode();
            }
        }
        return hash;
    }

    public static int arrayHashCode(byte[] arr) {
        int hash = 0;
        if (arr != null) {
            hash ^= arr.getClass().hashCode();
            for (int i = 0; i < arr.length; ++i) {
                hash ^= arr[i];
            }
        }
        return hash;
    }

    public static char[] arrayCopy(char[] chars) {
        if (chars == null) {
            return null;
        }
        char[] copy = new char[chars.length];
        System.arraycopy(chars, 0, copy, 0, chars.length);
        return copy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

