/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.util.Timer;

public class RateLimiter {
    private final Timer timer;
    private final long opDispersalPeriodNanos;
    private final AtomicLong lastOpTimeNanos;

    public static RateLimiter create(double maxOpsPerSecond) {
        return new RateLimiter(new Timer(), maxOpsPerSecond);
    }

    RateLimiter(Timer timer, double maxOpsPerSecond) {
        this.timer = timer;
        if (maxOpsPerSecond <= 0.0) {
            throw new IllegalArgumentException("RateLimiter max operations per second must be > 0 but was " + maxOpsPerSecond);
        }
        this.opDispersalPeriodNanos = (long)((double)TimeUnit.SECONDS.toNanos(1L) / maxOpsPerSecond);
        this.lastOpTimeNanos = new AtomicLong(Long.MIN_VALUE);
    }

    public double acquire() {
        boolean interrupted = false;
        long startTimeNanos = Long.MAX_VALUE;
        try {
            while (true) {
                long currTimeNanos = this.timer.monotonicNowNanos();
                startTimeNanos = Math.min(currTimeNanos, startTimeNanos);
                long lastOpTimeLocal = this.lastOpTimeNanos.get();
                long nextAllowedOpTime = lastOpTimeLocal + this.opDispersalPeriodNanos;
                if (currTimeNanos >= nextAllowedOpTime) {
                    boolean acquired = this.lastOpTimeNanos.compareAndSet(lastOpTimeLocal, currTimeNanos);
                    if (!acquired) continue;
                    double d = (double)(currTimeNanos - startTimeNanos) / (double)TimeUnit.SECONDS.toNanos(1L);
                    return d;
                }
                interrupted |= this.sleep(nextAllowedOpTime - currTimeNanos);
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    boolean sleep(long sleepTimeNanos) {
        long sleepTimeMillis = TimeUnit.NANOSECONDS.toMillis(sleepTimeNanos);
        try {
            Thread.sleep(sleepTimeMillis, (int)(sleepTimeNanos - TimeUnit.MILLISECONDS.toNanos(sleepTimeMillis)));
        }
        catch (InterruptedException ie) {
            return true;
        }
        return false;
    }
}

