/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;

public class EntityCacheKey {
    private final NameIdentifier identifier;
    private final Entity.EntityType type;

    public static EntityCacheKey of(NameIdentifier ident, Entity.EntityType type) {
        return new EntityCacheKey(ident, type);
    }

    EntityCacheKey(NameIdentifier identifier, Entity.EntityType type) {
        Preconditions.checkArgument((identifier != null ? 1 : 0) != 0, (Object)"identifier cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        this.identifier = identifier;
        this.type = type;
    }

    public NameIdentifier identifier() {
        return this.identifier;
    }

    public Entity.EntityType entityType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityCacheKey)) {
            return false;
        }
        EntityCacheKey other = (EntityCacheKey)obj;
        return Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.type});
    }

    public String toString() {
        String stringExpr = this.identifier.toString() + ":" + this.type.toString();
        return stringExpr;
    }
}

