/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.authorization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Audit;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;

public class RoleDTO
implements Role {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="audit")
    private AuditDTO audit;
    @Nullable
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="securableObjects")
    private SecurableObjectDTO[] securableObjects;

    protected RoleDTO() {
    }

    protected RoleDTO(String name, Map<String, String> properties, SecurableObjectDTO[] securableObjects, AuditDTO audit) {
        this.name = name;
        this.audit = audit;
        this.properties = properties;
        this.securableObjects = securableObjects;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public List<SecurableObject> securableObjects() {
        return Arrays.asList(this.securableObjects);
    }

    public Audit auditInfo() {
        return this.audit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected AuditDTO audit;
        protected Map<String, String> properties;
        protected SecurableObjectDTO[] securableObjects;

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.properties = properties;
            }
            return (S)this;
        }

        public S withSecurableObjects(SecurableObjectDTO[] securableObjects) {
            this.securableObjects = securableObjects;
            return (S)this;
        }

        public S withAudit(AuditDTO audit) {
            this.audit = audit;
            return (S)this;
        }

        public RoleDTO build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name cannot be null or empty");
            Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"audit cannot be null");
            Preconditions.checkArgument((this.securableObjects != null ? 1 : 0) != 0, (Object)"securable objects can't null");
            return new RoleDTO(this.name, this.properties, this.securableObjects, this.audit);
        }
    }
}

