/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class CatalogResponse
extends BaseResponse {
    @JsonProperty(value="catalog")
    private final CatalogDTO catalog;

    public CatalogResponse(CatalogDTO catalog) {
        super(0);
        this.catalog = catalog;
    }

    public CatalogResponse() {
        this.catalog = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.catalog != null, "catalog must not be null");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.catalog.name()), "catalog 'name' must not be null and empty");
        Preconditions.checkArgument(this.catalog.type() != null, "catalog 'type' must not be null");
        Preconditions.checkArgument(this.catalog.auditInfo() != null, "catalog 'audit' must not be null");
    }

    public CatalogDTO getCatalog() {
        return this.catalog;
    }

    @Override
    public String toString() {
        return "CatalogResponse(catalog=" + String.valueOf(this.getCatalog()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogResponse)) {
            return false;
        }
        CatalogResponse other = (CatalogResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogDTO this$catalog = this.getCatalog();
        CatalogDTO other$catalog = other.getCatalog();
        return !(this$catalog == null ? other$catalog != null : !((Object)this$catalog).equals(other$catalog));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CatalogResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CatalogDTO $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : ((Object)$catalog).hashCode());
        return result;
    }
}

